/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.RedstoneMode;
import appeng.api.config.SecurityPermissions;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.Extracells;
import extracells.part.PartFluidIO;
import extracells.render.TextureManager;
import extracells.util.PermissionUtil;
import java.util.ArrayList;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class PartFluidImport
extends PartFluidIO
implements IFluidHandler {
    @Override
    public int cableConnectionRenderTo() {
        return 5;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return false;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    @Override
    public TickRateModulation doWork(int rate, int TicksSinceLastCall) {
        int i;
        if (!this.isActive() || this.getFacingTank() == null) {
            return TickRateModulation.IDLE;
        }
        boolean empty = true;
        ArrayList<Fluid> filter = new ArrayList<Fluid>();
        filter.add(this.filterFluids[4]);
        if (this.filterSize >= 1) {
            for (i = 1; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        if (this.filterSize >= 2) {
            for (i = 0; i < 9; i = (int)((byte)(i + 2))) {
                if (i == 4) continue;
                filter.add(this.filterFluids[i]);
            }
        }
        for (Fluid fluid : filter) {
            if (fluid == null) continue;
            empty = false;
            if (!this.fillToNetwork(fluid, rate * TicksSinceLastCall)) continue;
            return TickRateModulation.FASTER;
        }
        return empty && this.fillToNetwork(null, rate * TicksSinceLastCall) ? TickRateModulation.FASTER : TickRateModulation.SLOWER;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        boolean redstonePowered = this.isRedstonePowered();
        if (resource == null || redstonePowered && this.getRedstoneMode() == RedstoneMode.LOW_SIGNAL || !redstonePowered && this.getRedstoneMode() == RedstoneMode.HIGH_SIGNAL) {
            return 0;
        }
        int drainAmount = Math.min(Extracells.basePartSpeed() + this.speedState * Extracells.basePartSpeed(), resource.amount);
        FluidStack toFill = new FluidStack(resource.getFluid(), drainAmount);
        Actionable action = doFill ? Actionable.MODULATE : Actionable.SIMULATE;
        IAEFluidStack filled = this.injectFluid(AEApi.instance().storage().createFluidStack(toFill), action);
        if (filled == null) {
            return toFill.amount;
        }
        return toFill.amount - (int)filled.getStackSize();
    }

    protected boolean fillToNetwork(Fluid fluid, int toDrain) {
        FluidStack drained;
        IFluidHandler facingTank = this.getFacingTank();
        ForgeDirection side = this.getSide();
        if (fluid == null) {
            drained = facingTank.drain(side.getOpposite(), toDrain, false);
        } else {
            drained = facingTank.drain(side.getOpposite(), new FluidStack(fluid, toDrain), false);
            if (drained != null && drained.getFluidID() != fluid.getID()) {
                return false;
            }
        }
        if (drained == null || drained.amount <= 0 || drained.getFluidID() <= 0) {
            return false;
        }
        IAEFluidStack toFill = AEApi.instance().storage().createFluidStack(drained);
        IAEFluidStack notInjected = this.injectFluid(toFill, Actionable.SIMULATE);
        int amount = toFill.getFluidStack().amount;
        if (notInjected != null) {
            amount -= notInjected.getFluidStack().amount;
        }
        if (amount > 0) {
            int returned;
            FluidStack actuallyDrained;
            if (fluid == null) {
                actuallyDrained = facingTank.drain(side.getOpposite(), amount, true);
            } else {
                actuallyDrained = facingTank.drain(side.getOpposite(), new FluidStack(toFill.getFluid(), amount), true);
                if (actuallyDrained != null && actuallyDrained.getFluidID() != fluid.getID()) {
                    return false;
                }
            }
            if (actuallyDrained == null || actuallyDrained.amount <= 0) {
                return false;
            }
            toFill.setStackSize((long)actuallyDrained.amount);
            IAEFluidStack actuallyNotInjected = this.injectFluid(toFill, Actionable.MODULATE);
            if (actuallyNotInjected != null && actuallyNotInjected.getStackSize() > 0L && (long)(returned = facingTank.fill(side.getOpposite(), actuallyNotInjected.getFluidStack(), true)) != actuallyNotInjected.getStackSize()) {
                FMLLog.severe((String)"[ExtraCells2] Import bus at %d:%d,%d,%d voided %d mL of %s", (Object[])new Object[]{this.tile.func_145831_w().field_73011_w.field_76574_g, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, actuallyNotInjected.getStackSize() - (long)returned, fluid.getName()});
            }
            return true;
        }
        return false;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(4.0, 4.0, 14.0, 12.0, 12.0, 16.0);
        bch.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
        bch.addBox(6.0, 6.0, 12.0, 10.0, 10.0, 13.0);
        bch.addBox(6.0, 6.0, 11.0, 10.0, 10.0, 12.0);
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[0];
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        return PermissionUtil.hasPermission(player, SecurityPermissions.BUILD, this) && super.onActivate(player, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.IMPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.IMPORT_FRONT.getTexture(), side, side);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderInventoryBox(renderer);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.setInvColor(AEColor.Cyan.blackVariant);
        ts.func_78380_c(0xF000F0);
        rh.renderInventoryFace(TextureManager.IMPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.IMPORT_SIDE.getTexture();
        rh.setTexture(side, side, side, TextureManager.IMPORT_FRONT.getTextures()[0], side, side);
        rh.setBounds(4.0f, 4.0f, 14.0f, 12.0f, 12.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        ts.func_78378_d(this.getHost().getColor().blackVariant);
        if (this.isActive()) {
            ts.func_78380_c(0xF000F0);
        }
        rh.renderFace(x, y, z, TextureManager.IMPORT_FRONT.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setTexture(side);
        rh.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 12.0f, 10.0f, 10.0f, 13.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setBounds(6.0f, 6.0f, 11.0f, 10.0f, 10.0f, 12.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }
}

