/*
 * Decompiled with CFR 0.152.
 */
package extracells.part;

import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IStackWatcher;
import appeng.api.networking.storage.IStackWatcherHost;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.api.util.AEColor;
import appeng.api.util.INetworkToolAgent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import extracells.part.PartECBase;
import extracells.render.TextureManager;
import extracells.util.FluidUtil;
import extracells.util.WrenchUtil;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class PartFluidStorageMonitor
extends PartECBase
implements IStackWatcherHost,
INetworkToolAgent {
    Fluid fluid = null;
    long amount = 0L;
    private Object dspList;
    boolean locked = false;
    IStackWatcher watcher = null;

    @Override
    public int cableConnectionRenderTo() {
        return 1;
    }

    protected void dropItems(World world, int x, int y, int z, ItemStack stack) {
        if (world == null) {
            return;
        }
        if (!world.field_72995_K) {
            float f = 0.7f;
            double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
            EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, stack);
            entityitem.field_145804_b = 10;
            world.func_72838_d((Entity)entityitem);
        }
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        bch.addBox(4.0, 4.0, 13.0, 12.0, 12.0, 14.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 13.0);
    }

    protected IMEMonitor<IAEFluidStack> getFluidStorage() {
        IGridNode n = this.getGridNode();
        if (n == null) {
            return null;
        }
        IGrid g = n.getGrid();
        if (g == null) {
            return null;
        }
        IStorageGrid storage = (IStorageGrid)g.getCache(IStorageGrid.class);
        if (storage == null) {
            return null;
        }
        return storage.getFluidInventory();
    }

    @Override
    public double getPowerUsage() {
        return 1.0;
    }

    @Override
    public int getLightLevel() {
        return this.isPowered() ? 9 : 0;
    }

    @Override
    public List<String> getWailaBodey(NBTTagCompound data, List<String> list) {
        int id;
        super.getWailaBodey(data, list);
        long amount = 0L;
        Fluid fluid = null;
        if (data.func_74764_b("locked") && data.func_74767_n("locked")) {
            list.add(StatCollector.func_74838_a((String)"waila.appliedenergistics2.Locked"));
        } else {
            list.add(StatCollector.func_74838_a((String)"waila.appliedenergistics2.Unlocked"));
        }
        if (data.func_74764_b("amount")) {
            amount = data.func_74763_f("amount");
        }
        if (data.func_74764_b("fluid") && (id = data.func_74762_e("fluid")) != -1) {
            fluid = FluidRegistry.getFluid((int)id);
        }
        if (fluid != null) {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + fluid.getLocalizedName(new FluidStack(fluid, 1000)));
            if (this.isActive()) {
                list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": " + amount + "mB");
            } else {
                list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB");
            }
        } else {
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.fluid") + ": " + StatCollector.func_74838_a((String)"extracells.tooltip.empty1"));
            list.add(StatCollector.func_74838_a((String)"extracells.tooltip.amount") + ": 0mB");
        }
        return list;
    }

    @Override
    public NBTTagCompound getWailaTag(NBTTagCompound tag) {
        super.getWailaTag(tag);
        tag.func_74757_a("locked", this.locked);
        tag.func_74772_a("amount", this.amount);
        if (this.fluid == null) {
            tag.func_74768_a("fluid", -1);
        } else {
            tag.func_74768_a("fluid", this.fluid.getID());
        }
        return tag;
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 pos) {
        if (player == null || player.field_70170_p == null) {
            return true;
        }
        if (player.field_70170_p.field_72995_K) {
            return true;
        }
        ItemStack s = player.func_71045_bC();
        if (s == null) {
            if (this.locked) {
                return false;
            }
            if (this.fluid == null) {
                return true;
            }
            if (this.watcher != null) {
                this.watcher.remove((Object)FluidUtil.createAEFluidStack(this.fluid));
            }
            this.fluid = null;
            this.amount = 0L;
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
            return true;
        }
        if (WrenchUtil.canWrench(s, player, this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e)) {
            this.locked = !this.locked;
            WrenchUtil.wrenchUsed(s, player, this.tile.field_145851_c, this.tile.field_145849_e, this.tile.field_145848_d);
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
            if (this.locked) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.appliedenergistics2.isNowLocked", new Object[0]));
            } else {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.appliedenergistics2.isNowUnlocked", new Object[0]));
            }
            return true;
        }
        if (this.locked) {
            return false;
        }
        if (FluidUtil.isFilled(s)) {
            if (this.fluid != null && this.watcher != null) {
                this.watcher.remove((Object)FluidUtil.createAEFluidStack(this.fluid));
            }
            this.fluid = FluidUtil.getFluidFromContainer(s).getFluid();
            if (this.watcher != null) {
                this.watcher.add((Object)FluidUtil.createAEFluidStack(this.fluid));
            }
            this.updateFluidAmount();
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
            return true;
        }
        return false;
    }

    protected void updateFluidAmount() {
        if (this.fluid != null) {
            IGridNode n = this.getGridNode();
            if (n == null) {
                return;
            }
            IGrid g = n.getGrid();
            if (g == null) {
                return;
            }
            IStorageGrid storage = (IStorageGrid)g.getCache(IStorageGrid.class);
            if (storage == null) {
                return;
            }
            IMEMonitor<IAEFluidStack> fluids = this.getFluidStorage();
            if (fluids == null) {
                return;
            }
            for (IAEFluidStack s : fluids.getStorageList()) {
                if (s.getFluid() != this.fluid) continue;
                this.amount = s.getStackSize();
                IPartHost host = this.getHost();
                if (host != null) {
                    host.markForUpdate();
                }
                return;
            }
            this.amount = 0L;
            IPartHost host = this.getHost();
            if (host != null) {
                host.markForUpdate();
            }
        }
    }

    public void onStackChange(IItemList arg0, IAEStack arg1, IAEStack arg2, BaseActionSource arg3, StorageChannel arg4) {
        this.updateFluidAmount();
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("amount")) {
            this.amount = data.func_74763_f("amount");
        }
        if (data.func_74764_b("fluid")) {
            int id = data.func_74762_e("fluid");
            this.fluid = id == -1 ? null : FluidRegistry.getFluid((int)id);
        }
        if (data.func_74764_b("locked")) {
            this.locked = data.func_74767_n("locked");
        }
    }

    @Override
    public boolean readFromStream(ByteBuf data) throws IOException {
        super.readFromStream(data);
        this.amount = data.readLong();
        int id = data.readInt();
        this.fluid = id == -1 ? null : FluidRegistry.getFluid((int)id);
        this.locked = data.readBoolean();
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderDynamic(double x, double y, double z, IPartRenderHelper rh, RenderBlocks renderer) {
        if (this.fluid == null) {
            return;
        }
        if (this.dspList == null) {
            this.dspList = GLAllocation.func_74526_a((int)1);
        }
        Tessellator tess = Tessellator.field_78398_a;
        if (!this.isActive()) {
            return;
        }
        IAEFluidStack ais = FluidUtil.createAEFluidStack(this.fluid);
        ais.setStackSize(this.amount);
        if (ais != null) {
            GL11.glPushMatrix();
            GL11.glTranslated((double)(x + 0.5), (double)(y + 0.5), (double)(z + 0.5));
            GL11.glNewList((int)((Integer)this.dspList), (int)4865);
            this.renderFluid(tess, ais);
            GL11.glEndList();
            GL11.glPopMatrix();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SideOnly(value=Side.CLIENT)
    private void renderFluid(Tessellator tess, IAEFluidStack fluidStack) {
        block17: {
            GL11.glPushAttrib((int)1048575);
            ForgeDirection d = this.getSide();
            GL11.glTranslated((double)((double)d.offsetX * 0.77), (double)((double)d.offsetY * 0.77), (double)((double)d.offsetZ * 0.77));
            if (d == ForgeDirection.UP) {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (d == ForgeDirection.DOWN) {
                GL11.glScalef((float)1.0f, (float)-1.0f, (float)1.0f);
                GL11.glRotatef((float)-90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            if (d == ForgeDirection.EAST) {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (d == ForgeDirection.WEST) {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (d == ForgeDirection.NORTH) {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
            }
            if (d == ForgeDirection.SOUTH) {
                GL11.glScalef((float)-1.0f, (float)-1.0f, (float)-1.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GL11.glPushMatrix();
            try {
                int br = 0x1000100;
                int var11 = br % 65536;
                int var12 = br / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)var11 * 0.8f), (float)((float)var12 * 0.8f));
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glDisable((int)2896);
                GL11.glDisable((int)32826);
                tess.func_78386_a(1.0f, 1.0f, 1.0f);
                IIcon fluidIcon = this.fluid.getIcon();
                if (fluidIcon == null) break block17;
                GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
                GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
                GL11.glTranslated((double)-8.6f, (double)-16.3, (double)-1.2f);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureMap.field_110575_b);
                Tessellator cake = Tessellator.field_78398_a;
                cake.func_78382_b();
                try {
                    cake.func_78380_c(255);
                    cake.func_78369_a((float)(this.fluid.getColor() >> 16 & 0xFF) / 255.0f, (float)(this.fluid.getColor() >> 8 & 0xFF) / 255.0f, (float)(this.fluid.getColor() & 0xFF) / 255.0f, 1.0f);
                    cake.func_78374_a(0.0, 16.0, 0.0, (double)fluidIcon.func_94209_e(), (double)fluidIcon.func_94210_h());
                    cake.func_78374_a(16.0, 16.0, 0.0, (double)fluidIcon.func_94212_f(), (double)fluidIcon.func_94210_h());
                    cake.func_78374_a(16.0, 0.0, 0.0, (double)fluidIcon.func_94212_f(), (double)fluidIcon.func_94206_g());
                    cake.func_78374_a(0.0, 0.0, 0.0, (double)fluidIcon.func_94209_e(), (double)fluidIcon.func_94206_g());
                }
                finally {
                    cake.func_78381_a();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        GL11.glPopMatrix();
        GL11.glTranslatef((float)0.0f, (float)0.14f, (float)-0.24f);
        GL11.glScalef((float)0.016129032f, (float)0.016129032f, (float)0.016129032f);
        long qty = fluidStack.getStackSize();
        if (qty > 999999999999L) {
            qty = 999999999999L;
        }
        String msg = Long.toString(qty) + "mB";
        if (qty > 1000000000L) {
            msg = Long.toString(qty / 1000000000L) + "MB";
        } else if (qty > 1000000L) {
            msg = Long.toString(qty / 1000000L) + "KB";
        } else if (qty > 9999L) {
            msg = Long.toString(qty / 1000L) + 'B';
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        int width = fr.func_78256_a(msg);
        GL11.glTranslatef((float)(-0.5f * (float)width), (float)0.0f, (float)-1.0f);
        fr.func_78276_b(msg, 0, 0, 0);
        GL11.glPopAttrib();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderInventoryBox(renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderInventoryBox(renderer);
        ts.func_78380_c(0xD000D0);
        rh.setInvColor(0xFFFFFF);
        rh.renderInventoryFace(TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        rh.setInvColor(AEColor.Transparent.blackVariant);
        rh.renderInventoryFace(TextureManager.STORAGE_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.mediumVariant);
        rh.renderInventoryFace(TextureManager.STORAGE_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        rh.setInvColor(AEColor.Transparent.whiteVariant);
        rh.renderInventoryFace(TextureManager.STORAGE_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderInventoryBusLights(rh, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper rh, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = TextureManager.TERMINAL_SIDE.getTexture();
        rh.setTexture(side);
        rh.setBounds(4.0f, 4.0f, 13.0f, 12.0f, 12.0f, 14.0f);
        rh.renderBlock(x, y, z, renderer);
        rh.setTexture(side, side, side, TextureManager.BUS_BORDER.getTexture(), side, side);
        rh.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        rh.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            Tessellator.field_78398_a.func_78380_c(0xD000D0);
        }
        ts.func_78378_d(0xFFFFFF);
        rh.renderFace(x, y, z, TextureManager.BUS_BORDER.getTexture(), ForgeDirection.SOUTH, renderer);
        IPartHost host = this.getHost();
        rh.setBounds(3.0f, 3.0f, 15.0f, 13.0f, 13.0f, 16.0f);
        ts.func_78378_d(host.getColor().mediumVariant);
        rh.renderFace(x, y, z, TextureManager.STORAGE_MONITOR.getTextures()[0], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().whiteVariant);
        rh.renderFace(x, y, z, TextureManager.STORAGE_MONITOR.getTextures()[1], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(host.getColor().blackVariant);
        rh.renderFace(x, y, z, TextureManager.STORAGE_MONITOR.getTextures()[2], ForgeDirection.SOUTH, renderer);
        rh.setBounds(5.0f, 5.0f, 12.0f, 11.0f, 11.0f, 13.0f);
        this.renderStaticBusLights(x, y, z, rh, renderer);
    }

    @Override
    public boolean requireDynamicRender() {
        return true;
    }

    public void updateWatcher(IStackWatcher w) {
        this.watcher = w;
        if (this.fluid != null) {
            w.add((Object)FluidUtil.createAEFluidStack(this.fluid));
        }
        this.onStackChange(null, null, null, null, null);
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74772_a("amount", this.amount);
        if (this.fluid == null) {
            data.func_74768_a("fluid", -1);
        } else {
            data.func_74768_a("fluid", this.fluid.getID());
        }
        data.func_74757_a("locked", this.locked);
    }

    @Override
    public void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        data.writeLong(this.amount);
        if (this.fluid == null) {
            data.writeInt(-1);
        } else {
            data.writeInt(this.fluid.getID());
        }
        data.writeBoolean(this.locked);
    }

    public boolean showNetworkInfo(MovingObjectPosition where) {
        return false;
    }
}

