/*
 * Decompiled with CFR 0.152.
 */
package extracells.tileentity;

import appeng.api.AEApi;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.ICellContainer;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.ICellRegistry;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.StorageChannel;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import extracells.api.IECTileEntity;
import extracells.gridblock.ECGridBlockHardMEDrive;
import extracells.tileentity.TileBase;
import extracells.util.inventory.ECPrivateInventory;
import extracells.util.inventory.IInventoryUpdateReceiver;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHardMeDrive
extends TileBase
implements IActionHost,
IECTileEntity,
ICellContainer,
IInventoryUpdateReceiver {
    private int priority = 0;
    boolean isFirstGridNode = true;
    byte[] cellStatuses = new byte[3];
    List<IMEInventoryHandler> fluidHandlers = new ArrayList<IMEInventoryHandler>();
    List<IMEInventoryHandler> itemHandlers = new ArrayList<IMEInventoryHandler>();
    private final ECGridBlockHardMEDrive gridBlock = new ECGridBlockHardMEDrive(this);
    private ECPrivateInventory inventory = new ECPrivateInventory("extracells.part.drive", 3, 1, this){
        ICellRegistry cellRegistry;
        {
            this.cellRegistry = AEApi.instance().registries().cell();
        }

        @Override
        public boolean func_94041_b(int i, ItemStack itemStack) {
            return this.cellRegistry.isCellHandled(itemStack);
        }
    };
    IGridNode node = null;

    public IInventory getInventory() {
        return this.inventory;
    }

    public void blinkCell(int i) {
    }

    public IGridNode getActionableNode() {
        return this.getGridNode(ForgeDirection.UNKNOWN);
    }

    public List<IMEInventoryHandler> getCellArray(StorageChannel channel) {
        if (!this.isActive()) {
            return new ArrayList<IMEInventoryHandler>();
        }
        return channel == StorageChannel.ITEMS ? this.itemHandlers : this.fluidHandlers;
    }

    public int getPriority() {
        return this.priority;
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    @Override
    public double getPowerUsage() {
        return 0.0;
    }

    public IGridNode getGridNode(ForgeDirection forgeDirection) {
        if (this.isFirstGridNode && this.func_145830_o() && !this.func_145831_w().field_72995_K) {
            this.isFirstGridNode = false;
            try {
                this.node = AEApi.instance().createGridNode((IGridBlock)this.gridBlock);
                this.node.updateState();
            }
            catch (Exception e) {
                this.isFirstGridNode = true;
            }
        }
        return this.node;
    }

    public AECableType getCableConnectionType(ForgeDirection forgeDirection) {
        return AECableType.SMART;
    }

    public void securityBreak() {
    }

    public void saveChanges(IMEInventory imeInventory) {
    }

    boolean isActive() {
        return true;
    }

    public int getColorByStatus(int status) {
        switch (status) {
            case 1: {
                return 65280;
            }
            case 2: {
                return 0xFFFF00;
            }
            case 3: {
                return 0xFF0000;
            }
        }
        return 0;
    }

    @Override
    public void onInventoryChanged() {
        this.itemHandlers = this.updateHandlers(StorageChannel.ITEMS);
        this.fluidHandlers = this.updateHandlers(StorageChannel.FLUIDS);
        for (int i = 0; i < this.cellStatuses.length; ++i) {
            ICellHandler cellHandler;
            ItemStack stackInSlot = this.inventory.func_70301_a(i);
            IMEInventoryHandler inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.ITEMS);
            if (inventoryHandler == null) {
                inventoryHandler = AEApi.instance().registries().cell().getCellInventory(stackInSlot, null, StorageChannel.FLUIDS);
            }
            this.cellStatuses[i] = (cellHandler = AEApi.instance().registries().cell().getHandler(stackInSlot)) == null || inventoryHandler == null ? (byte)0 : (byte)cellHandler.getStatusForCell(stackInSlot, (IMEInventory)inventoryHandler);
        }
        IGridNode node = this.getGridNode(ForgeDirection.UNKNOWN);
        if (node != null) {
            IGrid grid = node.getGrid();
            if (grid != null) {
                grid.postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            this.func_145831_w().func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    private List<IMEInventoryHandler> updateHandlers(StorageChannel channel) {
        ICellRegistry cellRegistry = AEApi.instance().registries().cell();
        ArrayList<IMEInventoryHandler> handlers = new ArrayList<IMEInventoryHandler>();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            IMEInventoryHandler cellInventory;
            ItemStack cell = this.inventory.func_70301_a(i);
            if (!cellRegistry.isCellHandled(cell) || (cellInventory = cellRegistry.getCellInventory(cell, null, channel)) == null) continue;
            handlers.add(cellInventory);
        }
        return handlers;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inventory.readFromNBT(tag.func_150295_c("inventory", 10));
        this.onInventoryChanged();
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.writeToNBT());
    }

    public Packet func_145844_m() {
        NBTTagCompound nbtTag = new NBTTagCompound();
        this.func_145841_b(nbtTag);
        int i = 0;
        for (byte aCellStati : this.cellStatuses) {
            nbtTag.func_74774_a("status#" + i, aCellStati);
            ++i;
        }
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 1, nbtTag);
    }
}

