/*
 * Decompiled with CFR 0.152.
 */
package extracells.util;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import cpw.mods.fml.common.FMLLog;
import extracells.item.ItemFluidPattern;
import extracells.registries.ItemEnum;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.apache.commons.lang3.tuple.MutablePair;

public class FluidUtil {
    public static IAEFluidStack createAEFluidStack(Fluid fluid) {
        return FluidUtil.createAEFluidStack(new FluidStack(fluid, 1000));
    }

    public static IAEFluidStack createAEFluidStack(Fluid fluid, long amount) {
        return FluidUtil.createAEFluidStack(fluid.getID(), amount);
    }

    public static IAEFluidStack createAEFluidStack(FluidStack fluid) {
        return AEApi.instance().storage().createFluidStack(fluid);
    }

    public static IAEFluidStack createAEFluidStack(int fluidId, long amount) {
        return (IAEFluidStack)FluidUtil.createAEFluidStack(new FluidStack(FluidRegistry.getFluid((int)fluidId), 1)).setStackSize(amount);
    }

    public static MutablePair<Integer, ItemStack> drainStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack drained = ((IFluidContainerItem)item).drain(itemStack, fluid.amount, true);
            int amountDrained = drained != null && drained.getFluid() == fluid.getFluid() ? drained.amount : 0;
            return new MutablePair((Object)amountDrained, (Object)itemStack);
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
            FluidStack content = FluidContainerRegistry.getFluidForFilledItem((ItemStack)itemStack);
            int amountDrained = content != null && content.getFluid() == fluid.getFluid() ? content.amount : 0;
            return new MutablePair((Object)amountDrained, (Object)FluidContainerRegistry.drainFluidContainer((ItemStack)itemStack));
        }
        return null;
    }

    public static MutablePair<Integer, ItemStack> fillStack(ItemStack itemStack, FluidStack fluid) {
        if (itemStack == null || itemStack.field_77994_a != 1) {
            return null;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            int filled = ((IFluidContainerItem)item).fill(itemStack, fluid, true);
            return new MutablePair((Object)filled, (Object)itemStack);
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
            ItemStack filledContainer = FluidContainerRegistry.fillFluidContainer((FluidStack)fluid, (ItemStack)itemStack);
            FluidStack filled = FluidContainerRegistry.getFluidForFilledItem((ItemStack)filledContainer);
            return new MutablePair((Object)(filled != null ? filled.amount : 0), (Object)filledContainer);
        }
        if (item == ItemEnum.FLUIDPATTERN.getItem()) {
            return new MutablePair((Object)0, (Object)ItemFluidPattern.getPatternForFluid(fluid.getFluid()));
        }
        return null;
    }

    public static MutablePair<ItemStack, FluidStack> fillItemFromAe(ItemStack container, FluidStack request, IMEMonitor<IAEFluidStack> monitor, Actionable mode, BaseActionSource src) {
        if (container == null || container.field_77994_a != 1) {
            return null;
        }
        if (request == null || request.amount <= 0) {
            return null;
        }
        if (monitor == null) {
            return null;
        }
        int capacity = FluidUtil.getCapacity(container, request.getFluid());
        int requestAmount = Integer.min(capacity, request.amount);
        IAEFluidStack result = (IAEFluidStack)monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(request.getFluid(), (long)requestAmount), mode, src);
        if (result == null || result.getStackSize() <= 0L) {
            return null;
        }
        if (!result.getFluid().equals(request.getFluid())) {
            FMLLog.severe((String)"[ExtraCells2] ME network returned fluid `%s` when requesting `%s`", (Object[])new Object[]{result.getFluid().getName(), request.getUnlocalizedName()});
            return null;
        }
        if (result.getStackSize() > (long)requestAmount) {
            FMLLog.severe((String)"[ExtraCells2] ME network returned %d mB of fluid `%s` when requesting %d mB", (Object[])new Object[]{result.getStackSize(), request.getUnlocalizedName(), requestAmount});
            return null;
        }
        MutablePair<Integer, ItemStack> filledContainer = FluidUtil.fillStack(container.func_77946_l(), result.getFluidStack());
        if ((Integer)filledContainer.getLeft() > (int)result.getStackSize()) {
            FMLLog.severe((String)"[ExtraCells2] %d mB of fluid `%s` filled container `%s` with %d mB: check fluid handler implementation", (Object[])new Object[]{result.getStackSize(), request.getUnlocalizedName(), container.func_77977_a(), filledContainer.getLeft()});
            return null;
        }
        if ((Integer)filledContainer.getLeft() < (int)result.getStackSize() && mode == Actionable.MODULATE) {
            int remaining = (int)result.getStackSize() - (Integer)filledContainer.getLeft();
            IAEFluidStack notAdded = (IAEFluidStack)monitor.injectItems((IAEStack)FluidUtil.createAEFluidStack(result.getFluid(), (long)remaining), Actionable.MODULATE, src);
            if (notAdded != null && notAdded.getStackSize() > 0L) {
                FMLLog.severe((String)"[ExtraCells2] %d mL of fluid `%s` voided when trying to fill container `%s`", (Object[])new Object[]{notAdded.getStackSize(), notAdded.getFluid().getName(), container.func_77977_a()});
            }
        }
        return new MutablePair(filledContainer.getRight(), (Object)new FluidStack(request.getFluid(), ((Integer)filledContainer.getLeft()).intValue()));
    }

    public static ItemStack drainItemIntoAe(ItemStack container, IMEMonitor<IAEFluidStack> monitor, Actionable mode, BaseActionSource src) {
        if (container == null || container.field_77994_a != 1) {
            return null;
        }
        if (monitor == null) {
            return null;
        }
        FluidStack fluidStack = FluidUtil.getFluidFromContainer(container);
        MutablePair<Integer, ItemStack> drained = FluidUtil.drainStack(container.func_77946_l(), fluidStack);
        fluidStack.amount = (Integer)drained.getLeft();
        IAEFluidStack notAdded = (IAEFluidStack)monitor.injectItems((IAEStack)FluidUtil.createAEFluidStack(fluidStack), mode, src);
        if (notAdded == null || notAdded.getStackSize() <= 0L) {
            return (ItemStack)drained.getRight();
        }
        if (!notAdded.getFluid().equals(fluidStack.getFluid())) {
            FMLLog.severe((String)"[ExtraCells2] ME network returned fluid `%s` when injecting `%s`", (Object[])new Object[]{notAdded.getFluid().getName(), fluidStack.getUnlocalizedName()});
            return null;
        }
        if (notAdded.getStackSize() > (long)fluidStack.amount) {
            FMLLog.severe((String)"[ExtraCells2] ME network returned %d mB of fluid `%s` when injecting %d mB", (Object[])new Object[]{notAdded.getStackSize(), fluidStack.getUnlocalizedName(), fluidStack.amount});
            return null;
        }
        fluidStack.amount -= (int)notAdded.getStackSize();
        MutablePair<Integer, ItemStack> partiallyDrained = FluidUtil.drainStack(container.func_77946_l(), fluidStack);
        if ((Integer)partiallyDrained.getLeft() > fluidStack.amount) {
            FMLLog.severe((String)"[ExtraCells2] Voided fluid: %d mB of fluid `%s` drained from container `%s` with %d mB: check fluid handler implementation", (Object[])new Object[]{notAdded.getStackSize(), fluidStack.getUnlocalizedName(), container.func_77977_a(), partiallyDrained.getLeft()});
            return (ItemStack)partiallyDrained.getRight();
        }
        if ((Integer)partiallyDrained.getLeft() < fluidStack.amount) {
            if (mode == Actionable.MODULATE) {
                int duped = fluidStack.amount - (Integer)partiallyDrained.getLeft();
                IAEFluidStack extracted = (IAEFluidStack)monitor.extractItems((IAEStack)FluidUtil.createAEFluidStack(notAdded.getFluid(), (long)duped), Actionable.MODULATE, src);
                if (extracted == null || extracted.getStackSize() < (long)duped) {
                    FMLLog.severe((String)"[ExtraCells2] %d mL of fluid `%s` duped when trying to empty container `%s`", (Object[])new Object[]{extracted == null ? (long)duped : (long)duped - extracted.getStackSize(), notAdded.getFluid().getName(), container.func_77977_a()});
                }
            } else {
                return null;
            }
        }
        return (ItemStack)partiallyDrained.getRight();
    }

    public static int getCapacity(ItemStack itemStack, Fluid fluid) {
        if (itemStack == null) {
            return 0;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem fluidContainerItem = (IFluidContainerItem)item;
            int capacity = fluidContainerItem.getCapacity(itemStack);
            FluidStack existing = fluidContainerItem.getFluid(itemStack);
            if (existing != null) {
                if (!existing.getFluid().equals(fluid)) {
                    return 0;
                }
                capacity -= existing.amount;
            }
            return capacity;
        }
        if (FluidContainerRegistry.isContainer((ItemStack)itemStack)) {
            return FluidContainerRegistry.getContainerCapacity((FluidStack)new FluidStack(fluid, Integer.MAX_VALUE), (ItemStack)itemStack);
        }
        return 0;
    }

    public static FluidStack getFluidFromContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        ItemStack container = itemStack.func_77946_l();
        Item item = container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            return ((IFluidContainerItem)item).getFluid(container);
        }
        if (item == ItemEnum.FLUIDPATTERN.getItem()) {
            return new FluidStack(ItemFluidPattern.getFluid(itemStack), 0);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)container);
    }

    public static boolean isEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
            return content == null || content.amount <= 0;
        }
        return item == ItemEnum.FLUIDPATTERN.getItem() || FluidContainerRegistry.isEmptyContainer((ItemStack)itemStack);
    }

    public static boolean isFilled(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            FluidStack content = ((IFluidContainerItem)item).getFluid(itemStack);
            return content != null && content.amount > 0;
        }
        return FluidContainerRegistry.isFilledContainer((ItemStack)itemStack);
    }

    public static boolean isFluidContainer(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return item instanceof IFluidContainerItem || item == ItemEnum.FLUIDPATTERN.getItem() || FluidContainerRegistry.isContainer((ItemStack)itemStack);
    }

    public static String formatFluidAmount(long millibuckets, boolean forceLongForm) {
        if (!forceLongForm) {
            if (millibuckets >= 1000000000000L) {
                return String.format("%.1fG", (double)millibuckets / 1.0E12);
            }
            if (millibuckets >= 1000000000L) {
                return String.format("%.1fM", (double)millibuckets / 1.0E9);
            }
            if (millibuckets >= 1000000L) {
                return String.format("%.1fk", (double)millibuckets / 1000000.0);
            }
            if (millibuckets >= 1000L) {
                return String.format("%.1f", (double)millibuckets / 1000.0);
            }
        }
        return String.format("%,d%s", millibuckets, forceLongForm ? " mB" : "m");
    }

    public static IItemList<IAEFluidStack> filterEmptyFluid(IItemList<IAEFluidStack> _fluidStackList) {
        IItemList temp = AEApi.instance().storage().createFluidList();
        for (IAEFluidStack fluid : _fluidStackList) {
            if (fluid.getStackSize() <= 0L) continue;
            temp.add((IAEStack)fluid);
        }
        return temp;
    }

    public static String formatFluidAmount(long millibuckets) {
        return FluidUtil.formatFluidAmount(millibuckets, false);
    }
}

