/*
 * Decompiled with CFR 0.152.
 */
package extracells.block;

import appeng.api.implementations.items.IAEWrench;
import buildcraft.api.tools.IToolWrench;
import extracells.block.BlockEC;
import extracells.network.ChannelHandler;
import extracells.registries.BlockEnum;
import extracells.render.RenderHandler;
import extracells.tileentity.TileEntityCertusTank;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;

public class BlockCertusTank
extends BlockEC {
    IIcon breakIcon;
    IIcon topIcon;
    IIcon bottomIcon;
    IIcon sideIcon;
    IIcon sideMiddleIcon;
    IIcon sideTopIcon;
    IIcon sideBottomIcon;

    public BlockCertusTank() {
        super(Material.field_151592_s, 2.0f, 10.0f);
        this.func_149676_a(0.0625f, 0.0f, 0.0625f, 0.9375f, 1.0f, 0.9375f);
    }

    public boolean canRenderInPass(int pass) {
        RenderHandler.renderPass = pass;
        return true;
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileEntityCertusTank();
    }

    public ItemStack getDropWithNBT(World world, int x, int y, int z) {
        NBTTagCompound tileEntity = new NBTTagCompound();
        TileEntity worldTE = world.func_147438_o(x, y, z);
        if (worldTE instanceof TileEntityCertusTank) {
            ItemStack dropStack = new ItemStack(BlockEnum.CERTUSTANK.getBlock(), 1);
            ((TileEntityCertusTank)worldTE).writeToNBTWithoutCoords(tileEntity);
            if (!tileEntity.func_74764_b("Empty")) {
                dropStack.func_77982_d(new NBTTagCompound());
                dropStack.field_77990_d.func_74782_a("tileEntity", (NBTBase)tileEntity);
            }
            return dropStack;
        }
        return null;
    }

    public IIcon func_149691_a(int side, int b) {
        switch (b) {
            case 1: {
                return this.sideTopIcon;
            }
            case 2: {
                return this.sideBottomIcon;
            }
            case 3: {
                return this.sideMiddleIcon;
            }
        }
        return side == 0 ? this.bottomIcon : (side == 1 ? this.topIcon : this.sideIcon);
    }

    public String func_149732_F() {
        return StatCollector.func_74838_a((String)(this.func_149739_a() + ".name"));
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        return this.getDropWithNBT(world, x, y, z);
    }

    public int func_149701_w() {
        return 1;
    }

    public int func_149645_b() {
        return RenderHandler.getId();
    }

    public String func_149739_a() {
        return super.func_149739_a().replace("tile.", "");
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149727_a(World worldObj, int x, int y, int z, EntityPlayer entityplayer, int blockID, float offsetX, float offsetY, float offsetZ) {
        ItemStack current = entityplayer.field_71071_by.func_70448_g();
        if (entityplayer.func_70093_af() && current != null) {
            try {
                if (current.func_77973_b() instanceof IToolWrench && ((IToolWrench)current.func_77973_b()).canWrench(entityplayer, x, y, z)) {
                    this.func_149642_a(worldObj, x, y, z, this.getDropWithNBT(worldObj, x, y, z));
                    worldObj.func_147468_f(x, y, z);
                    ((IToolWrench)current.func_77973_b()).wrenchUsed(entityplayer, x, y, z);
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (current.func_77973_b() instanceof IAEWrench && ((IAEWrench)current.func_77973_b()).canWrench(current, entityplayer, x, y, z)) {
                this.func_149642_a(worldObj, x, y, z, this.getDropWithNBT(worldObj, x, y, z));
                worldObj.func_147468_f(x, y, z);
                return true;
            }
        }
        if (current != null) {
            ItemStack filled;
            FluidStack liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)current);
            TileEntityCertusTank tank = (TileEntityCertusTank)worldObj.func_147438_o(x, y, z);
            if (liquid != null) {
                int amountFilled = tank.fill(ForgeDirection.UNKNOWN, liquid, true);
                if (amountFilled != 0 && !entityplayer.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a > 1) {
                        --entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c].field_77994_a;
                        entityplayer.field_71071_by.func_70441_a(current.func_77973_b().getContainerItem(current));
                    } else {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = current.func_77973_b().getContainerItem(current);
                    }
                }
                return true;
            }
            FluidStack available = tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid;
            if (available != null && (liquid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)(filled = FluidContainerRegistry.fillFluidContainer((FluidStack)available, (ItemStack)current)))) != null) {
                tank.drain(ForgeDirection.UNKNOWN, liquid.amount, true);
                if (!entityplayer.field_71075_bZ.field_75098_d) {
                    if (current.field_77994_a == 1) {
                        entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c] = filled;
                    } else {
                        --entityplayer.field_71071_by.field_70462_a[entityplayer.field_71071_by.field_70461_c].field_77994_a;
                        if (!entityplayer.field_71071_by.func_70441_a(filled)) {
                            entityplayer.func_70099_a(filled, 0.0f);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block neighborBlock) {
        if (!world.field_72995_K) {
            ChannelHandler.sendPacketToAllPlayers(world.func_147438_o(x, y, z).func_145844_m(), world);
        }
    }

    public void func_149651_a(IIconRegister iconregister) {
        this.breakIcon = iconregister.func_94245_a("extracells:certustank");
        this.topIcon = iconregister.func_94245_a("extracells:CTankTop");
        this.bottomIcon = iconregister.func_94245_a("extracells:CTankBottom");
        this.sideIcon = iconregister.func_94245_a("extracells:CTankSide");
        this.sideMiddleIcon = iconregister.func_94245_a("extracells:CTankSideMiddle");
        this.sideTopIcon = iconregister.func_94245_a("extracells:CTankSideTop");
        this.sideBottomIcon = iconregister.func_94245_a("extracells:CTankSideBottom");
    }

    public boolean func_149686_d() {
        return false;
    }
}

