/*
 * Decompiled with CFR 0.152.
 */
package extracells.gridblock;

import appeng.api.networking.GridFlags;
import appeng.api.networking.GridNotification;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridBlock;
import appeng.api.networking.IGridHost;
import appeng.api.networking.IGridNode;
import appeng.api.networking.storage.IStorageGrid;
import appeng.api.parts.PartItemStack;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.util.AEColor;
import appeng.api.util.DimensionalCoord;
import extracells.gridblock.Constants;
import extracells.part.PartECBase;
import java.util.EnumSet;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class ECBaseGridBlock
implements IGridBlock {
    protected AEColor color;
    protected IGrid grid;
    protected int usedChannels;
    protected PartECBase host;

    public ECBaseGridBlock(PartECBase _host) {
        this.host = _host;
    }

    public final EnumSet<ForgeDirection> getConnectableSides() {
        return EnumSet.noneOf(ForgeDirection.class);
    }

    public EnumSet<GridFlags> getFlags() {
        return Constants.BASE_GRID_FLAGS;
    }

    public IMEMonitor<IAEFluidStack> getFluidMonitor() {
        IGridNode node = this.host.getGridNode();
        if (node == null) {
            return null;
        }
        IGrid grid = node.getGrid();
        if (grid == null) {
            return null;
        }
        IStorageGrid storageGrid = (IStorageGrid)grid.getCache(IStorageGrid.class);
        if (storageGrid == null) {
            return null;
        }
        return storageGrid.getFluidInventory();
    }

    public final AEColor getGridColor() {
        return this.color == null ? AEColor.Transparent : this.color;
    }

    public double getIdlePowerUsage() {
        return this.host.getPowerUsage();
    }

    public final DimensionalCoord getLocation() {
        return this.host.getLocation();
    }

    public IGridHost getMachine() {
        return this.host;
    }

    public ItemStack getMachineRepresentation() {
        return this.host.getItemStack(PartItemStack.Network);
    }

    public void gridChanged() {
    }

    public final boolean isWorldAccessible() {
        return false;
    }

    public void onGridNotification(GridNotification notification) {
    }

    public final void setNetworkStatus(IGrid _grid, int _usedChannels) {
        this.grid = _grid;
        this.usedChannels = _usedChannels;
    }
}

