/*
 * Decompiled with CFR 0.152.
 */
package de.keridos.floodlights.tileentity;

import de.keridos.floodlights.handler.ConfigHandler;
import de.keridos.floodlights.tileentity.TileEntityMetaFloodlight;
import de.keridos.floodlights.util.GeneralUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityCarbonFloodlight
extends TileEntityMetaFloodlight {
    public int timeRemaining = 0;

    @Override
    public void readOwnFromNBT(NBTTagCompound nbtTagCompound) {
        NBTTagList list;
        NBTTagCompound item;
        byte slot;
        super.readOwnFromNBT(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("timeRemaining")) {
            this.timeRemaining = nbtTagCompound.func_74762_e("timeRemaining");
        }
        if ((slot = (item = (list = nbtTagCompound.func_150295_c("Items", 10)).func_150305_b(0)).func_74771_c("Items")) >= 0 && slot < this.func_70302_i_()) {
            this.func_70299_a(slot, ItemStack.func_77949_a((NBTTagCompound)item));
        }
    }

    @Override
    public void writeOwnToNBT(NBTTagCompound nbtTagCompound) {
        super.writeOwnToNBT(nbtTagCompound);
        nbtTagCompound.func_74768_a("timeRemaining", this.timeRemaining);
        NBTTagList list = new NBTTagList();
        ItemStack itemstack = this.func_70301_a(0);
        if (itemstack != null) {
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Items", (byte)0);
            itemstack.func_77955_b(item);
            list.func_74742_a((NBTBase)item);
        }
        nbtTagCompound.func_74782_a("Items", (NBTBase)list);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return i == 0 && GeneralUtil.getBurnTime(itemstack) > 0;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemstack) {
        return GeneralUtil.getBurnTime(itemstack) > 0;
    }

    public void func_145845_h() {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            if (this.timeRemaining == 0 && this.inventory[0] != null) {
                this.timeRemaining = ConfigHandler.carbonTime * GeneralUtil.getBurnTime(this.inventory[0]) / 1600 * (this.mode == 0 ? 20 : 10);
                this.func_70298_a(0, 1);
            }
            if (this.timeout > 0) {
                --this.timeout;
                return;
            }
            if (this.active && this.timeRemaining > 0) {
                if (this.update) {
                    this.removeSource(this.mode);
                    this.addSource(this.mode);
                    world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.getOrientation().ordinal() + 6, 2);
                    this.update = false;
                } else if (!this.wasActive) {
                    this.addSource(this.mode);
                    world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) + 6, 2);
                }
                --this.timeRemaining;
                this.wasActive = true;
            } else if (this.wasActive) {
                this.removeSource(this.mode);
                world.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, world.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e) - 6, 2);
                this.wasActive = false;
                this.timeout = ConfigHandler.timeoutFloodlights;
                this.update = false;
            }
        }
    }

    public void addSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(false);
        } else if (mode == 1) {
            this.narrowConeSource(false);
        } else if (mode == 2) {
            this.wideConeSource(false);
        }
    }

    public void removeSource(int mode) {
        if (mode == -1) {
            mode = this.mode;
        }
        if (mode == 0) {
            this.straightSource(true);
        } else if (mode == 1) {
            this.narrowConeSource(true);
        } else if (mode == 2) {
            this.wideConeSource(true);
        }
    }

    public void changeMode(EntityPlayer player) {
        World world = this.func_145831_w();
        if (!world.field_72995_K) {
            ForgeDirection direction = this.getOrientation();
            this.removeSource(this.mode);
            int n = this.mode = this.mode == 2 ? 0 : this.mode + 1;
            if (this.mode == 1) {
                this.timeRemaining /= 4;
            } else if (this.mode == 0) {
                this.timeRemaining *= 4;
            }
            if (this.active && this.timeRemaining > 0) {
                this.addSource(this.mode);
            }
            String modeString = this.mode == 0 ? "gui.floodlights:straight" : (this.mode == 1 ? "gui.floodlights:narrowCone" : "gui.floodlights:wideCone");
            player.func_145747_a((IChatComponent)new ChatComponentText(GeneralUtil.safeLocalize("gui.floodlights:mode") + ": " + GeneralUtil.safeLocalize(modeString)));
        }
    }
}

