/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuitBoard;
import forestry.core.circuits.ISocketable;
import forestry.core.gui.IContainerSocketed;
import forestry.core.network.packets.PacketChipsetClick;
import forestry.core.network.packets.PacketSocketUpdate;
import forestry.core.network.packets.PacketSolderingIronClick;
import forestry.core.proxy.Proxies;
import forestry.core.utils.InventoryUtil;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class ContainerSocketedHelper<T extends TileEntity>
implements IContainerSocketed {
    private final T tile;

    public ContainerSocketedHelper(T tile) {
        this.tile = tile;
    }

    @Override
    public void handleChipsetClick(int slot) {
        Proxies.net.sendToServer(new PacketChipsetClick((TileEntity)this.tile, slot));
    }

    @Override
    public void handleChipsetClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        if (((ISocketable)this.tile).getSocket(slot) != null) {
            return;
        }
        if (!ChipsetManager.circuitRegistry.isChipset(itemstack)) {
            return;
        }
        ICircuitBoard circuitBoard = ChipsetManager.circuitRegistry.getCircuitboard(itemstack);
        if (circuitBoard == null) {
            return;
        }
        try {
            if (!((ISocketable)this.tile).getSocketType().equals(circuitBoard.getSocketType())) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ItemStack toSocket = itemstack.func_77946_l();
        toSocket.field_77994_a = 1;
        ((ISocketable)this.tile).setSocket(slot, toSocket);
        ItemStack stack = player.field_71071_by.func_70445_o();
        --stack.field_77994_a;
        if (stack.field_77994_a <= 0) {
            player.field_71071_by.func_70437_b(null);
        }
        player.func_71113_k();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
    }

    @Override
    public void handleSolderingIronClick(int slot) {
        Proxies.net.sendToServer(new PacketSolderingIronClick((TileEntity)this.tile, slot));
    }

    @Override
    public void handleSolderingIronClickServer(int slot, EntityPlayerMP player, ItemStack itemstack) {
        ItemStack socket = ((ISocketable)this.tile).getSocket(slot);
        if (socket == null) {
            return;
        }
        InventoryUtil.stowInInventory(socket, (IInventory)player.field_71071_by, true);
        if (socket.field_77994_a > 0) {
            return;
        }
        ((ISocketable)this.tile).setSocket(slot, null);
        itemstack.func_77972_a(1, (EntityLivingBase)player);
        if (itemstack.field_77994_a <= 0) {
            player.field_71071_by.func_70437_b(null);
        }
        player.func_71113_k();
        PacketSocketUpdate packet = new PacketSocketUpdate(this.tile);
        Proxies.net.sendToPlayer(packet, (EntityPlayer)player);
    }
}

