/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui;

import forestry.core.gui.GuiForestryTitled;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.gui.ledgers.SearchIngregientsLedger;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.proxy.Proxies;
import forestry.core.recipes.RecipeUtil;
import forestry.core.tiles.IIngredientsSearchController;
import forestry.core.tiles.IngredientsStorage;
import forestry.core.utils.InventoryUtil;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.gui.widgets.ClearWorktable;
import forestry.factory.gui.widgets.MemorizedRecipeSlot;
import forestry.factory.recipes.MemorizedRecipe;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class GuiWorktable
extends GuiForestryTitled<ContainerWorktable, TileWorktable>
implements IIngredientsSearchController {
    private static final int SPACING = 18;
    private boolean hasRecipeConflict = false;
    private final EntityPlayer player;

    public GuiWorktable(EntityPlayer player, TileWorktable tile) {
        super("textures/gui/worktable2.png", new ContainerWorktable(player, tile), tile);
        this.player = player;
        this.field_147000_g = 218;
        RecipeMemory recipeMemory = tile.getMemory();
        int slot = 0;
        for (int y = 0; y < 3; ++y) {
            int yPos = 20 + y * 18;
            for (int x = 0; x < 3; ++x) {
                int xPos = 110 + x * 18;
                MemorizedRecipeSlot memorizedRecipeSlot = new MemorizedRecipeSlot(this.widgetManager, xPos, yPos, recipeMemory, slot++);
                this.widgetManager.add(memorizedRecipeSlot);
            }
        }
        this.widgetManager.add(new ClearWorktable(this.widgetManager, 66, 19));
    }

    @Override
    protected void addLedgers() {
        super.addLedgers();
        this.ledgerManager.add(new SearchIngregientsLedger(this.ledgerManager, this));
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.hasRecipeConflict != ((TileWorktable)this.inventory).hasRecipeConflict()) {
            this.hasRecipeConflict = ((TileWorktable)this.inventory).hasRecipeConflict();
            if (this.hasRecipeConflict) {
                this.addButtons();
            } else {
                this.field_146292_n.clear();
            }
        }
    }

    public void func_73863_a(int mouseX, int mouseY, float parTicks) {
        MemorizedRecipe recipe;
        super.func_73863_a(mouseX, mouseY, parTicks);
        Slot itemSlot = (Slot)this.field_147002_h.field_75151_b.get(63);
        if (this.func_146978_c(itemSlot.field_75223_e, itemSlot.field_75221_f, 16, 16, mouseX, mouseY) && !((TileWorktable)this.inventory).canTakeStack(this.player, 9) && (recipe = ((TileWorktable)this.inventory).getCurrentRecipe()) != null) {
            ItemStack[] recipeItems = InventoryUtil.getStacks((IInventory)recipe.getCraftMatrix());
            ItemStack[] availableItems = InventoryUtil.getStacks(this.inventory);
            ItemStack[] ingregients = RecipeUtil.getCraftIngredients(recipeItems, availableItems);
            for (int slot = 0; slot < ingregients.length; ++slot) {
                if (ingregients[slot] != null || recipeItems[slot] == null) continue;
                this.renderSlotOverlay((Slot)this.field_147002_h.field_75151_b.get(54 + slot));
            }
        }
    }

    private void renderSlotOverlay(Slot slot) {
        int left = this.field_147003_i + slot.field_75223_e;
        int top = this.field_147009_r + slot.field_75221_f;
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)150.0f);
        GuiWorktable.func_73734_a((int)left, (int)top, (int)(left + 16), (int)(top + 16), (int)-1996554240);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-150.0f);
        GL11.glEnable((int)2896);
    }

    private void addButtons() {
        this.field_146292_n.add(new GuiBetterButton(0, this.field_147003_i + 76, this.field_147009_r + 56, StandardButtonTextureSets.LEFT_BUTTON_SMALL));
        this.field_146292_n.add(new GuiBetterButton(1, this.field_147003_i + 85, this.field_147009_r + 56, StandardButtonTextureSets.RIGHT_BUTTON_SMALL));
    }

    protected void func_146284_a(GuiButton button) {
        int id = 100 + button.field_146127_k;
        Proxies.net.sendToServer(new PacketGuiSelectRequest(id, 0));
    }

    @Override
    public IngredientsStorage getIngredientsStorage() {
        return ((ContainerWorktable)this.container).getIngredientsStorage();
    }

    @Override
    public void setIngredientsStorage(IngredientsStorage ingredientsStorage) {
        Proxies.net.sendToServer(new PacketGuiSelectRequest(200, ingredientsStorage.ordinal()));
    }
}

