/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ISolderManager;
import forestry.core.circuits.CircuitRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class SolderManager
implements ISolderManager {
    private static final List<CircuitRecipe> recipes = new ArrayList<CircuitRecipe>();

    @Override
    public void addRecipe(ICircuitLayout layout, ItemStack resource, ICircuit circuit) {
        if (layout == null) {
            throw new IllegalArgumentException("layout may not be null");
        }
        if (resource == null) {
            throw new IllegalArgumentException("resource may not be null");
        }
        if (circuit == null) {
            throw new IllegalArgumentException("circuit may not be null");
        }
        recipes.add(new CircuitRecipe(layout, resource, circuit));
    }

    public static ICircuit getCircuit(ICircuitLayout layout, ItemStack resource) {
        CircuitRecipe circuitRecipe = SolderManager.getMatchingRecipe(layout, resource);
        if (circuitRecipe == null) {
            return null;
        }
        return circuitRecipe.getCircuit();
    }

    public static CircuitRecipe getMatchingRecipe(ICircuitLayout layout, ItemStack resource) {
        if (layout == null || resource == null) {
            return null;
        }
        for (CircuitRecipe recipe : recipes) {
            if (!recipe.matches(layout, resource)) continue;
            return recipe;
        }
        return null;
    }
}

