/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.fluids;

import forestry.core.utils.InventoryUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.plugins.PluginFluids;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;

public final class FluidHelper {
    private FluidHelper() {
    }

    public static boolean handleRightClick(IFluidHandler tank, ForgeDirection side, EntityPlayer player, boolean fill, boolean drain) {
        if (player == null) {
            return false;
        }
        ItemStack current = player.field_71071_by.func_70448_g();
        if (current != null) {
            ItemStack filled;
            FluidStack available;
            FluidStack liquid = FluidHelper.getFluidStackInContainer(current);
            if (fill && liquid != null) {
                int canUseAmount = tank.fill(side, liquid, false);
                if (canUseAmount == 0) {
                    return false;
                }
                ItemStack drainedContainer = FluidHelper.getDrainedContainer(current, canUseAmount);
                if (ItemStackUtil.isIdenticalItem(current, drainedContainer)) {
                    return false;
                }
                int usedAmount = tank.fill(side, liquid, true);
                if (usedAmount > 0) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        if (current.field_77994_a > 1) {
                            player.field_71071_by.func_70298_a(player.field_71071_by.field_70461_c, 1);
                            if (drainedContainer != null && !player.field_71071_by.func_70441_a(drainedContainer)) {
                                player.func_71019_a(drainedContainer, false);
                            }
                        } else {
                            player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, drainedContainer);
                        }
                        player.field_71071_by.func_70296_d();
                    }
                    return true;
                }
            } else if (drain && (available = tank.drain(side, Integer.MAX_VALUE, false)) != null && (liquid = FluidHelper.getFluidStackInContainer(filled = FluidHelper.getFilledContainer(available, current))) != null) {
                if (current.field_77994_a > 1) {
                    if (!player.field_71071_by.func_70441_a(filled)) {
                        return false;
                    }
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InventoryUtil.depleteItem(current));
                    player.field_71071_by.func_70296_d();
                } else {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, InventoryUtil.depleteItem(current));
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, filled);
                    player.field_71071_by.func_70296_d();
                }
                tank.drain(side, liquid.amount, true);
                return true;
            }
        }
        return false;
    }

    public static boolean areFluidStacksEqual(FluidStack fluidStack1, FluidStack fluidStack2) {
        if (fluidStack1 == null) {
            return fluidStack2 == null;
        }
        return fluidStack1.isFluidStackIdentical(fluidStack2);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill) {
        return FluidHelper.fillContainers(fluidHandler, inv, inputSlot, outputSlot, fluidToFill, true);
    }

    public static FillStatus fillContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot, Fluid fluidToFill, boolean doFill) {
        boolean moveToOutput;
        FluidStack canDrain;
        if (fluidToFill == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack input = inv.func_70301_a(inputSlot);
        if (input == null) {
            return FillStatus.INVALID_INPUT;
        }
        ItemStack output = inv.func_70301_a(outputSlot);
        int containerCapacity = FluidHelper.getFluidCapacity(fluidToFill, input);
        if (containerCapacity <= 0) {
            return FillStatus.INVALID_INPUT;
        }
        int fillAmount = containerCapacity;
        if (input.func_77973_b() instanceof IFluidContainerItem) {
            fillAmount = Math.min(1000, containerCapacity);
        }
        if ((canDrain = fluidHandler.drain(ForgeDirection.UNKNOWN, new FluidStack(fluidToFill, fillAmount), false)) == null || canDrain.amount == 0) {
            return FillStatus.NO_FLUID;
        }
        ItemStack filled = FluidHelper.getFilledContainer(canDrain, input);
        if (filled == null) {
            return FillStatus.NO_FLUID;
        }
        FluidStack fluidInContainer = FluidHelper.getFluidStackInContainer(filled);
        if (fluidInContainer == null) {
            return FillStatus.INVALID_INPUT;
        }
        boolean bl = moveToOutput = fluidInContainer.amount >= containerCapacity;
        if (moveToOutput ? output != null && (output.field_77994_a >= output.func_77976_d() || !InventoryUtil.isItemEqual(filled, output)) : input.field_77994_a > 1) {
            return FillStatus.NO_SPACE;
        }
        if (doFill) {
            fluidHandler.drain(ForgeDirection.UNKNOWN, canDrain, true);
            if (moveToOutput) {
                if (output == null) {
                    inv.func_70299_a(outputSlot, filled);
                } else {
                    ++output.field_77994_a;
                }
                inv.func_70298_a(inputSlot, 1);
            } else {
                inv.func_70299_a(inputSlot, filled);
            }
        }
        return FillStatus.SUCCESS;
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int slot) {
        return FluidHelper.drainContainers(fluidHandler, inv, slot, slot);
    }

    public static boolean drainContainers(IFluidHandler fluidHandler, IInventory inv, int inputSlot, int outputSlot) {
        Item item;
        int used;
        ItemStack drainedItem;
        ItemStack input = inv.func_70301_a(inputSlot);
        ItemStack output = inv.func_70301_a(outputSlot);
        if (input == null) {
            return false;
        }
        FluidStack fluidInContainer = FluidHelper.getFluidStackInContainer(input);
        if (fluidInContainer == null) {
            return false;
        }
        if (input.func_77973_b() instanceof IFluidContainerItem && fluidInContainer.amount > 1000) {
            fluidInContainer.amount = 1000;
        }
        if (ItemStack.func_77989_b((ItemStack)input, (ItemStack)(drainedItem = FluidHelper.getDrainedContainer(input, used = fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, false))))) {
            return false;
        }
        if (outputSlot == inputSlot && drainedItem != null && (PluginFluids.items.canEmpty == (item = drainedItem.func_77973_b()) || PluginFluids.items.waxCapsuleEmpty == item || PluginFluids.items.refractoryEmpty == item)) {
            drainedItem = null;
        }
        if (!FluidHelper.hasRoomForDrainedContainer(input, output, drainedItem, inputSlot, outputSlot)) {
            return false;
        }
        fluidHandler.fill(ForgeDirection.UNKNOWN, fluidInContainer, true);
        if (drainedItem != null) {
            if (outputSlot == inputSlot) {
                inv.func_70299_a(outputSlot, drainedItem);
                return true;
            }
            if (output == null) {
                inv.func_70299_a(outputSlot, drainedItem);
            } else {
                ++output.field_77994_a;
            }
        }
        inv.func_70298_a(inputSlot, 1);
        return true;
    }

    private static boolean hasRoomForDrainedContainer(ItemStack input, ItemStack output, ItemStack drainedItem, int inputSlot, int outputSlot) {
        if (output == null || drainedItem == null) {
            return true;
        }
        if (outputSlot == inputSlot) {
            return input.field_77994_a == 1;
        }
        if (!ItemStackUtil.isIdenticalItem(output, drainedItem)) {
            return false;
        }
        return output.field_77994_a + drainedItem.field_77994_a <= output.func_77976_d();
    }

    public static boolean isEmptyContainer(ItemStack empty) {
        Item item = empty.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack fluid = containerItem.getFluid(empty);
            return fluid == null || fluid.amount == 0;
        }
        return FluidContainerRegistry.isEmptyContainer((ItemStack)empty);
    }

    public static boolean isFillableContainer(ItemStack container) {
        FluidStack fluid = FluidHelper.getFluidStackInContainer(container);
        if (fluid == null || fluid.amount == 0) {
            return FluidHelper.isEmptyContainer(container);
        }
        int capacity = FluidHelper.getFluidCapacity(fluid.getFluid(), container);
        return fluid.amount < capacity;
    }

    public static ItemStack getDrainedContainer(ItemStack container, int drainAmount) {
        if (container == null) {
            return null;
        }
        if (drainAmount == 0) {
            return container;
        }
        Item item = container.func_77973_b();
        if (item == null) {
            return null;
        }
        if (item instanceof IFluidContainerItem) {
            ItemStack drained = container.func_77946_l();
            drained.field_77994_a = 1;
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.drain(drained, drainAmount, true);
            return drained;
        }
        int capacity = FluidContainerRegistry.getContainerCapacity((ItemStack)container);
        if (capacity > 0) {
            if (drainAmount < capacity) {
                return container;
            }
            return FluidContainerRegistry.drainFluidContainer((ItemStack)container);
        }
        return null;
    }

    public static ItemStack getEmptyContainer(ItemStack container) {
        if (container == null) {
            return null;
        }
        FluidStack fluidStack = FluidHelper.getFluidStackInContainer(container);
        if (fluidStack == null) {
            return null;
        }
        return FluidHelper.getDrainedContainer(container, fluidStack.amount);
    }

    public static List<ItemStack> getAllFilledContainers(ItemStack empty) {
        ArrayList<ItemStack> filledContainers = new ArrayList<ItemStack>();
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            ItemStack filledContainer = FluidHelper.getFilledContainer(fluid, empty);
            if (filledContainer == null) continue;
            filledContainers.add(filledContainer);
        }
        return filledContainers;
    }

    public static ItemStack getFilledContainer(Fluid fluid, ItemStack empty) {
        if (fluid == null) {
            return null;
        }
        FluidStack fluidToFill = new FluidStack(fluid, Integer.MAX_VALUE);
        return FluidHelper.getFilledContainer(fluidToFill, empty);
    }

    public static ItemStack getFilledContainer(FluidStack liquid, ItemStack empty) {
        if (liquid == null || empty == null) {
            return null;
        }
        Item item = empty.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            ItemStack full = ItemStackUtil.createSplitStack(empty, 1);
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            containerItem.fill(full, liquid, true);
            return full;
        }
        return FluidContainerRegistry.fillFluidContainer((FluidStack)liquid, (ItemStack)empty);
    }

    public static FluidStack getFluidStackInContainer(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.getFluid(stack);
        }
        return FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
    }

    public static Fluid getFluidInContainer(ItemStack stack) {
        FluidStack fluidStack = FluidHelper.getFluidStackInContainer(stack);
        return fluidStack != null ? fluidStack.getFluid() : null;
    }

    public static boolean containsFluidStack(ItemStack stack, FluidStack fluidStack) {
        Item item = stack.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            FluidStack contained = containerItem.getFluid(stack);
            return contained != null && contained.containsFluid(fluidStack);
        }
        return FluidContainerRegistry.containsFluid((ItemStack)stack, (FluidStack)fluidStack);
    }

    public static boolean containsFluid(ItemStack stack, Fluid fluid) {
        return FluidHelper.containsFluidStack(stack, new FluidStack(fluid, 1));
    }

    public static int getFluidCapacity(Fluid fluid, ItemStack container) {
        if (container == null) {
            return 0;
        }
        Item item = container.func_77973_b();
        if (item instanceof IFluidContainerItem) {
            IFluidContainerItem containerItem = (IFluidContainerItem)item;
            return containerItem.getCapacity(container);
        }
        if (fluid == null) {
            return FluidContainerRegistry.getContainerCapacity((ItemStack)container);
        }
        return FluidContainerRegistry.getContainerCapacity((FluidStack)new FluidStack(fluid, 1000), (ItemStack)container);
    }

    public static enum FillStatus {
        SUCCESS,
        INVALID_INPUT,
        NO_FLUID,
        NO_SPACE;

    }
}

