/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.gui.widgets;

import forestry.core.gui.widgets.ItemStackWidgetBase;
import forestry.core.gui.widgets.WidgetManager;
import forestry.core.proxy.Proxies;
import forestry.core.render.SpriteSheet;
import forestry.core.render.TextureManager;
import forestry.factory.gui.ContainerWorktable;
import forestry.factory.recipes.RecipeMemory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import org.lwjgl.opengl.GL11;

public class MemorizedRecipeSlot
extends ItemStackWidgetBase {
    private static final IIcon lockIcon = TextureManager.getInstance().getDefault("slots/locked");
    private final RecipeMemory recipeMemory;
    private final int slotNumber;

    public MemorizedRecipeSlot(WidgetManager manager, int xPos, int yPos, RecipeMemory recipeMemory, int slot) {
        super(manager, xPos, yPos);
        this.recipeMemory = recipeMemory;
        this.slotNumber = slot;
    }

    @Override
    public ItemStack getItemStack() {
        return this.recipeMemory.getRecipeDisplayOutput(this.slotNumber);
    }

    @Override
    public void draw(int startX, int startY) {
        super.draw(startX, startY);
        GL11.glPushAttrib((int)8192);
        GL11.glDisable((int)2929);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        if (this.recipeMemory.isLocked(this.slotNumber)) {
            this.manager.gui.setZLevel(110.0f);
            Proxies.render.bindTexture(SpriteSheet.ITEMS);
            this.manager.gui.func_94065_a(startX + this.xPos, startY + this.yPos, lockIcon, 16, 16);
            this.manager.gui.setZLevel(0.0f);
        }
        GL11.glPopAttrib();
    }

    @Override
    public void handleMouseClick(int mouseX, int mouseY, int mouseButton) {
        if (this.getItemStack() != null) {
            ContainerWorktable.sendRecipeClick(mouseButton, this.slotNumber);
        }
    }
}

