/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.network.packets;

import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import forestry.factory.recipes.RecipeMemory;
import forestry.factory.tiles.TileWorktable;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketWorktableMemoryUpdate
extends PacketCoordinates
implements IForestryPacketClient {
    private RecipeMemory recipeMemory;

    public PacketWorktableMemoryUpdate() {
    }

    public PacketWorktableMemoryUpdate(TileWorktable worktable) {
        super(worktable);
        this.recipeMemory = worktable.getMemory();
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.recipeMemory.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof TileWorktable) {
            ((TileWorktable)tile).getMemory().readData(data);
        }
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.WORKTABLE_MEMORY_UPDATE;
    }
}

