/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.blocks;

import forestry.apiculture.tiles.TileApiaristChest;
import forestry.apiculture.tiles.TileApiary;
import forestry.apiculture.tiles.TileBeehouse;
import forestry.core.blocks.IMachineProperties;
import forestry.core.tiles.TileForestry;
import java.util.Locale;
import org.apache.commons.lang3.text.WordUtils;

public enum BlockApicultureType implements IMachineProperties
{
    APIARY(TileApiary.class),
    APIARIST_CHEST_LEGACY(TileApiaristChest.class, "ApiaristChest"),
    BEEHOUSE(TileBeehouse.class);

    public static final BlockApicultureType[] VALUES;
    private final String teIdent;
    private final Class<? extends TileForestry> teClass;

    private BlockApicultureType(Class<? extends TileForestry> teClass) {
        String name = this.toString().toLowerCase(Locale.ENGLISH);
        this.teIdent = "forestry." + WordUtils.capitalize((String)name);
        this.teClass = teClass;
    }

    private BlockApicultureType(Class<? extends TileForestry> teClass, String name) {
        this.teIdent = "forestry." + name;
        this.teClass = teClass;
    }

    @Override
    public int getMeta() {
        return this.ordinal();
    }

    @Override
    public String getTeIdent() {
        return this.teIdent;
    }

    @Override
    public Class<? extends TileForestry> getTeClass() {
        return this.teClass;
    }

    static {
        VALUES = BlockApicultureType.values();
    }
}

