/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.network.packets;

import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeekeepingLogic;
import forestry.apiculture.BeekeepingLogic;
import forestry.core.network.DataInputStreamForestry;
import forestry.core.network.DataOutputStreamForestry;
import forestry.core.network.IForestryPacketClient;
import forestry.core.network.PacketIdClient;
import forestry.core.network.packets.PacketCoordinates;
import forestry.core.proxy.Proxies;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;

public class PacketBeeLogicActive
extends PacketCoordinates
implements IForestryPacketClient {
    private BeekeepingLogic beekeepingLogic;

    public PacketBeeLogicActive() {
    }

    public PacketBeeLogicActive(IBeeHousing tile) {
        super(tile.getCoordinates());
        this.beekeepingLogic = (BeekeepingLogic)tile.getBeekeepingLogic();
    }

    @Override
    public PacketIdClient getPacketId() {
        return PacketIdClient.BEE_LOGIC_ACTIVE;
    }

    @Override
    protected void writeData(DataOutputStreamForestry data) throws IOException {
        super.writeData(data);
        this.beekeepingLogic.writeData(data);
    }

    @Override
    public void onPacketData(DataInputStreamForestry data, EntityPlayer player) throws IOException {
        IBeeHousing beeHousing;
        IBeekeepingLogic beekeepingLogic;
        TileEntity tile = this.getTarget(Proxies.common.getRenderWorld());
        if (tile instanceof IBeeHousing && (beekeepingLogic = (beeHousing = (IBeeHousing)tile).getBeekeepingLogic()) instanceof BeekeepingLogic) {
            ((BeekeepingLogic)beekeepingLogic).readData(data);
        }
    }
}

