/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmLogic;
import forestry.core.entities.EntitySelector;
import forestry.core.render.SpriteSheet;
import forestry.core.utils.EntityUtil;
import forestry.core.utils.vect.MutableVect;
import forestry.core.utils.vect.Vect;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public abstract class FarmLogic
implements IFarmLogic {
    private final EntitySelectorFarm entitySelectorFarm = new EntitySelectorFarm(this);
    protected final IFarmHousing housing;
    protected boolean isManual;
    protected final MutableVect mutableVect = new MutableVect();

    protected FarmLogic(IFarmHousing housing) {
        this.housing = housing;
    }

    @Override
    public FarmLogic setManual(boolean flag) {
        this.isManual = flag;
        return this;
    }

    protected World getWorld() {
        return this.housing.getWorld();
    }

    @Override
    public ResourceLocation getSpriteSheet() {
        return SpriteSheet.ITEMS.getLocation();
    }

    public abstract boolean isAcceptedWindfall(ItemStack var1);

    protected final boolean isAirBlock(Block block) {
        return block.func_149688_o() == Material.field_151579_a;
    }

    protected final boolean isWaterSourceBlock(World world, Vect position) {
        return world.func_147439_a(position.x, position.y, position.z) == Blocks.field_150355_j && world.func_72805_g(position.x, position.y, position.z) == 0;
    }

    protected final Vect translateWithOffset(int x, int y, int z, FarmDirection farmDirection, int step) {
        return new Vect(this.mutableVect.set(farmDirection.getForgeDirection()).multiply(step).add(x, y, z));
    }

    protected final void setBlock(Vect position, Block block, int meta) {
        this.getWorld().func_147465_d(position.x, position.y, position.z, block, meta, 3);
    }

    private AxisAlignedBB getHarvestBox(IFarmHousing farmHousing, boolean toWorldHeight) {
        Vect coords = new Vect(farmHousing.getCoords());
        Vect area = new Vect(farmHousing.getArea());
        Vect offset = new Vect(farmHousing.getOffset());
        Vect min = coords.add(offset);
        Vect max = min.add(area);
        int maxY = max.y;
        if (toWorldHeight) {
            maxY = this.getWorld().func_72800_K();
        }
        return AxisAlignedBB.func_72330_a((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)maxY, (double)max.z);
    }

    protected List<ItemStack> collectEntityItems(boolean toWorldHeight) {
        AxisAlignedBB harvestBox = this.getHarvestBox(this.housing, toWorldHeight);
        List<EntityItem> entityItems = EntityUtil.selectEntitiesWithinAABB(this.housing.getWorld(), this.entitySelectorFarm, harvestBox);
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (EntityItem entity : entityItems) {
            ItemStack contained = entity.func_92059_d();
            stacks.add(contained.func_77946_l());
            entity.func_70106_y();
        }
        return stacks;
    }

    private static class EntitySelectorFarm
    extends EntitySelector<EntityItem> {
        private final FarmLogic farmLogic;

        public EntitySelectorFarm(FarmLogic farmLogic) {
            super(EntityItem.class);
            this.farmLogic = farmLogic;
        }

        @Override
        protected boolean isEntityApplicableTyped(EntityItem entity) {
            if (entity.field_70128_L) {
                return false;
            }
            ItemStack contained = entity.func_92059_d();
            return this.farmLogic.isAcceptedGermling(contained) || this.farmLogic.isAcceptedWindfall(contained);
        }
    }
}

