/*
 * Decompiled with CFR 0.152.
 */
package codechicken.microblock;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import codechicken.microblock.FaceMicroClass$;
import codechicken.microblock.HollowMicroClass$;
import codechicken.microblock.HollowMicroblock;
import codechicken.microblock.ISidedHollowConnect;
import codechicken.microblock.Microblock;
import codechicken.multipart.TMultiPart;
import codechicken.multipart.TileMultipart;
import java.util.List;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.runtime.BoxesRunTime;

public abstract class HollowMicroblock$class {
    public static HollowMicroClass$ microClass(HollowMicroblock $this) {
        return HollowMicroClass$.MODULE$;
    }

    public static Cuboid6 getBounds(HollowMicroblock $this) {
        return FaceMicroClass$.MODULE$.aBounds()[((Microblock)((Object)$this)).shape()];
    }

    public static List getPartialOcclusionBoxes(HollowMicroblock $this) {
        return JavaConversions$.MODULE$.seqAsJavaList(HollowMicroClass$.MODULE$.pBoxes()[((Microblock)((Object)$this)).shape()]);
    }

    public static int getHollowSize(HollowMicroblock $this) {
        int n;
        TileMultipart tileMultipart = ((TMultiPart)((Object)$this)).tile();
        if (tileMultipart == null) {
            n = 8;
        } else {
            int n2;
            TMultiPart tMultiPart = ((TMultiPart)((Object)$this)).tile().partMap(6);
            if (tMultiPart instanceof ISidedHollowConnect) {
                TMultiPart tMultiPart2 = tMultiPart;
                n2 = ((ISidedHollowConnect)((Object)tMultiPart2)).getHollowSize($this.getSlot());
            } else {
                n2 = 8;
            }
            n = n2;
        }
        return n;
    }

    public static Iterable getOcclusionBoxes(HollowMicroblock $this) {
        List list;
        int size = $this.getHollowSize();
        Cuboid6 c = HollowMicroClass$.MODULE$.occBounds()[((Microblock)((Object)$this)).shape()];
        double d1 = 0.5 - (double)size / 32.0;
        double d2 = 0.5 + (double)size / 32.0;
        double x1 = c.min.x;
        double x2 = c.max.x;
        double y1 = c.min.y;
        double y2 = c.max.y;
        double z1 = c.min.z;
        double z2 = c.max.z;
        int n = $this.getSlot();
        switch (n) {
            default: {
                throw new MatchError((Object)BoxesRunTime.boxToInteger((int)n));
            }
            case 4: 
            case 5: {
                list = JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cuboid6[]{new Cuboid6(x1, d1, d2, x2, d2, z2), new Cuboid6(x1, d1, z1, x2, d2, d1), new Cuboid6(x1, d2, z1, x2, y2, z2), new Cuboid6(x1, y1, z1, x2, d1, z2)})));
                break;
            }
            case 2: 
            case 3: {
                list = JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cuboid6[]{new Cuboid6(d1, d2, z1, d2, y2, z2), new Cuboid6(d1, y1, z1, d2, d1, z2), new Cuboid6(d2, y1, z1, x2, y2, z2), new Cuboid6(x1, y1, z1, d1, y2, z2)})));
                break;
            }
            case 0: 
            case 1: {
                list = JavaConversions$.MODULE$.seqAsJavaList((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cuboid6[]{new Cuboid6(d2, y1, d1, x2, y2, d2), new Cuboid6(x1, y1, d1, d1, y2, d2), new Cuboid6(x1, y1, d2, x2, y2, z2), new Cuboid6(x1, y1, z1, x2, y2, d1)})));
            }
        }
        return list;
    }

    public static List getCollisionBoxes(HollowMicroblock $this) {
        int size = $this.getHollowSize();
        double d1 = 0.5 - (double)size / 32.0;
        double d2 = 0.5 + (double)size / 32.0;
        double t = (double)(((Microblock)((Object)$this)).shape() >> 4) / 8.0;
        Transformation tr = Rotation.sideRotations[((Microblock)((Object)$this)).shape() & 0xF].at(Vector3.center);
        return JavaConversions$.MODULE$.seqAsJavaList((Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Cuboid6[]{new Cuboid6(0.0, 0.0, 0.0, 1.0, t, d1), new Cuboid6(0.0, 0.0, d2, 1.0, t, 1.0), new Cuboid6(0.0, 0.0, d1, d1, t, d2), new Cuboid6(d2, 0.0, d1, 1.0, t, d2)}))).map((Function1)new Serializable($this, tr){
            private final Transformation tr$1;

            public final Cuboid6 apply(Cuboid6 c) {
                return c.apply(this.tr$1);
            }
            {
                this.tr$1 = tr$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public static List getSubParts(HollowMicroblock $this) {
        return JavaConversions$.MODULE$.bufferAsJavaList((Buffer)JavaConversions$.MODULE$.asScalaBuffer($this.getCollisionBoxes()).map((Function1)new Serializable($this){

            public final IndexedCuboid6 apply(Cuboid6 c) {
                return new IndexedCuboid6((Object)BoxesRunTime.boxToInteger((int)0), c);
            }
        }, Buffer$.MODULE$.canBuildFrom()));
    }

    public static boolean allowCompleteOcclusion(HollowMicroblock $this) {
        return true;
    }

    public static boolean solid(HollowMicroblock $this, int side) {
        return false;
    }

    public static int redstoneConductionMap(HollowMicroblock $this) {
        return 16;
    }

    public static void $init$(HollowMicroblock $this) {
    }
}

