/*
 * Decompiled with CFR 0.152.
 */
package com.detrav.utils;

import com.detrav.net.ProspectingPacket;
import gregtech.api.enums.Materials;
import java.util.Arrays;
import java.util.Objects;
import net.minecraftforge.fluids.FluidRegistry;

public class FluidColors {
    public static void makeColors() {
        FluidColors.reFillFluidColors();
        Arrays.stream(Materials.values()).forEach(mat -> {
            if (mat.getSolid(0L) != null) {
                ProspectingPacket.fluidColors.putIfAbsent(mat.getSolid(0L).getFluidID(), mat.mRGBa);
            }
            if (mat.getGas(0L) != null) {
                ProspectingPacket.fluidColors.putIfAbsent(mat.getGas(0L).getFluidID(), mat.mRGBa);
            }
            if (mat.getFluid(0L) != null) {
                ProspectingPacket.fluidColors.putIfAbsent(mat.getFluid(0L).getFluidID(), mat.mRGBa);
            }
            if (mat.getMolten(0L) != null) {
                ProspectingPacket.fluidColors.putIfAbsent(mat.getMolten(0L).getFluidID(), mat.mRGBa);
            }
        });
        FluidRegistry.getRegisteredFluids().values().stream().filter(Objects::nonNull).forEach(fluid -> ProspectingPacket.fluidColors.putIfAbsent(fluid.getID(), FluidColors.convertColorInt(fluid.getColor())));
    }

    private static void reFillFluidColors() {
        try {
            ProspectingPacket.fluidColors.put(Materials.NatruralGas.mGas.getID(), new short[]{0, 255, 255});
            ProspectingPacket.fluidColors.put(Materials.OilLight.mFluid.getID(), new short[]{255, 255, 0});
            ProspectingPacket.fluidColors.put(Materials.OilMedium.mFluid.getID(), new short[]{0, 255, 0});
            ProspectingPacket.fluidColors.put(Materials.OilHeavy.mFluid.getID(), new short[]{255, 0, 255});
            ProspectingPacket.fluidColors.put(Materials.Oil.mFluid.getID(), new short[]{0, 0, 0});
            ProspectingPacket.fluidColors.put(Materials.Helium_3.mGas.getID(), new short[]{128, 32, 224});
            ProspectingPacket.fluidColors.put(Materials.SaltWater.mFluid.getID(), new short[]{128, 255, 128});
            ProspectingPacket.fluidColors.put(Materials.Lead.getMolten(0L).getFluid().getID(), new short[]{208, 208, 208});
            ProspectingPacket.fluidColors.put(Materials.Chlorobenzene.mFluid.getID(), new short[]{64, 128, 64});
            ProspectingPacket.fluidColors.put(FluidRegistry.getFluid((String)"liquid_extra_heavy_oil").getID(), new short[]{0, 0, 80});
            ProspectingPacket.fluidColors.put(Materials.Oxygen.mGas.getID(), new short[]{64, 64, 160});
            ProspectingPacket.fluidColors.put(Materials.Nitrogen.mGas.getID(), new short[]{0, 128, 208});
            ProspectingPacket.fluidColors.put(Materials.Methane.mGas.getID(), new short[]{128, 32, 32});
            ProspectingPacket.fluidColors.put(Materials.Ethane.mGas.getID(), new short[]{64, 128, 32});
            ProspectingPacket.fluidColors.put(Materials.Ethylene.mGas.getID(), new short[]{208, 208, 208});
            ProspectingPacket.fluidColors.put(FluidRegistry.LAVA.getID(), new short[]{255, 0, 0});
            ProspectingPacket.fluidColors.put(FluidRegistry.getFluid((String)"unknowwater").getID(), new short[]{138, 43, 226});
            ProspectingPacket.fluidColors.put(Materials.Hydrogen.mGas.getID(), new short[]{50, 50, 214});
            ProspectingPacket.fluidColors.put(Materials.SulfuricAcid.mFluid.getID(), new short[]{255, 185, 15});
            ProspectingPacket.fluidColors.put(Materials.HydricSulfide.mFluid.getID(), new short[]{255, 143, 67});
            ProspectingPacket.fluidColors.put(Materials.CarbonMonoxide.mGas.getID(), new short[]{16, 78, 139});
            ProspectingPacket.fluidColors.put(Materials.CarbonDioxide.mGas.getID(), new short[]{105, 105, 105});
            ProspectingPacket.fluidColors.put(FluidRegistry.getFluid((String)"ic2distilledwater").getID(), new short[]{30, 144, 255});
            ProspectingPacket.fluidColors.put(Materials.Deuterium.mGas.getID(), new short[]{255, 227, 159});
            ProspectingPacket.fluidColors.put(Materials.Iron.getMolten(0L).getFluid().getID(), new short[]{139, 136, 120});
            ProspectingPacket.fluidColors.put(Materials.Tin.getMolten(0L).getFluid().getID(), new short[]{231, 231, 228});
            ProspectingPacket.fluidColors.put(Materials.Copper.getMolten(0L).getFluid().getID(), new short[]{255, 127, 36});
            ProspectingPacket.fluidColors.put(FluidRegistry.getFluid((String)"fluorine").getID(), new short[]{153, 193, 173});
            ProspectingPacket.fluidColors.put(FluidRegistry.getFluid((String)"hydrofluoricacid").getID(), new short[]{0, 206, 209});
            ProspectingPacket.fluidColors.put(Materials.PhosphoricAcid.mFluid.getID(), new short[]{238, 118, 0});
            ProspectingPacket.fluidColors.put(Materials.LiquidAir.mFluid.getID(), new short[]{153, 153, 234});
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static short[] convertColorInt(int color) {
        return new short[]{(short)(color << 16 & 0xFF), (short)(color << 8 & 0xFF), (short)(color & 0xFF)};
    }
}

