/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.wands;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import gregtech.api.util.GT_ModHandler;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.wands.StaffRod;
import thaumcraft.api.wands.WandCap;
import thaumcraft.api.wands.WandRod;
import thaumcraft.common.lib.crafting.ArcaneSceptreRecipe;
import thaumcraft.common.lib.crafting.ArcaneWandRecipe;

@Mod(modid="gtnhtcwands", name="GTNH-TC-Wands", version="1.0.4", dependencies="required-after:Thaumcraft;required-after:dreamcraft;required-after:gregtech;required-after:TwilightForest;after:ForbiddenMagic;after:TaintedMagic;after:BloodArsenal;after:thaumicbases;after:ThaumicExploration;after:ThaumicTinkerer;")
public class ThaumcraftWands {
    static final String dependencies = "required-after:Thaumcraft;required-after:dreamcraft;required-after:gregtech;required-after:TwilightForest;after:ForbiddenMagic;after:TaintedMagic;after:BloodArsenal;after:thaumicbases;after:ThaumicExploration;after:ThaumicTinkerer;";
    @Mod.Instance
    public static ThaumcraftWands instance = new ThaumcraftWands();
    static final String[] cores = new String[]{"wood", "greatwood", "reed", "blaze", "obsidian", "ice", "quartz", "bone", "silverwood", "greatwood_staff", "reed_staff", "blaze_staff", "obsidian_staff", "ice_staff", "quartz_staff", "bone_staff", "silverwood_staff", "ICHORCLOTH", "primal_staff", "blood_wood", "blood_wood_staff", "blood", "blood_staff", "infernal", "tbthaumium", "tbvoid", "livingwood", "dreamwood", "dreamwood_staff", "witchwood", "witchwood_staff", "AMBER", "AMBER_staff", "TRANSMUTATION", "TRANSMUTATION_staff", "warpwood", "warpwood_staff", "BREAD"};
    static final String[] caps = new String[]{"iron", "copper", "gold", "silver", "thaumium", "void", "ICHOR", "alchemical", "blood_iron", "cloth", "crimsoncloth", "shadowcloth", "shadowmetal", "thauminite", "manasteel", "terrasteel", "elementium", "vinteum", "SOJOURNER", "MECHANIST"};
    static ItemStack[] conductor = null;
    static final String[] screw = new String[]{"screwAluminium", "screwStainlessSteel", "screwTitanium", "screwTungstenSteel", "screwChrome", "screwIridium", "screwOsmium"};

    @Mod.EventHandler
    public void postinit(FMLPostInitializationEvent e) {
        ThaumcraftWands.removeTCWands();
        this.addWandParts();
        this.setConstants();
        ThaumcraftWands.makeWands();
    }

    private void setConstants() {
        conductor = new ItemStack[]{GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.nagaScale", (long)1L), GT_ModHandler.getModItem((String)"dreamcraft", (String)"item.LichBone", (long)1L), GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.fieryBlood", (long)1L), GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.fieryTears", (long)1L), GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.carminite", (long)1L), GT_ModHandler.getModItem((String)"dreamcraft", (String)"item.SnowQueenBlood", (long)1L)};
    }

    private void addWandParts() {
        ThaumcraftWands.makeCap(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemWandCap", (long)1L, (int)3), "shadowcloth", 0.85f, 7, new ResourceLocation("taintedmagic", "textures/models/ModelWAND_CAP_SHADOW_CLOTH.png"));
        ThaumcraftWands.makeCap(GT_ModHandler.getModItem((String)"TaintedMagic", (String)"ItemWandCap", (long)1L, (int)2), "crimsoncloth", 0.8f, 9, new ResourceLocation("taintedmagic", "textures/models/ModelWAND_CAP_CRIMSON_CLOTH.png"));
    }

    public static void makeWands() {
        for (String rod : cores) {
            for (String cap : caps) {
                if (WandCap.caps.get(cap) == null || ThaumcraftWands.getWandRod(rod) == null) continue;
                int meta = ((WandCap)WandCap.caps.get(cap)).getCraftCost() * ThaumcraftWands.getWandRod(rod).getCraftCost();
                ItemStack wand = GT_ModHandler.getModItem((String)"Thaumcraft", (String)"WandCasting", (long)1L, (int)meta);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("rod", rod);
                nbt.func_74778_a("cap", cap);
                wand.func_77982_d(nbt);
                AspectList list = new AspectList();
                for (Aspect a : Aspect.getPrimalAspects()) {
                    list.add(a, ThaumcraftWands.getVisCost(rod, cap, false));
                }
                if (rod == "warpwood") {
                    ThaumcraftApi.addArcaneCraftingRecipe((String)"RoD_WarpwoodGTNH", (ItemStack)wand, (AspectList)list, (Object[])ThaumcraftWands.getRecipe(rod, cap, false));
                } else if (rod == "warpwood_staff") {
                    ThaumcraftApi.addArcaneCraftingRecipe((String)("RoD_Warpwood_StaffGTNH" + rod), (ItemStack)wand, (AspectList)list, (Object[])ThaumcraftWands.getRecipe(rod, cap, false));
                } else {
                    ThaumcraftApi.addArcaneCraftingRecipe((String)("ROD_" + rod), (ItemStack)wand, (AspectList)list, (Object[])ThaumcraftWands.getRecipe(rod, cap, false));
                }
                list = new AspectList();
                for (Aspect a : Aspect.getPrimalAspects()) {
                    list.add(a, ThaumcraftWands.getVisCost(rod, cap, true));
                }
                wand.func_77964_b((int)((float)wand.func_77960_j() * 1.5f));
                nbt.func_74774_a("sceptre", (byte)1);
                ThaumcraftApi.addArcaneCraftingRecipe((String)"SCEPTRE", (ItemStack)wand, (AspectList)list, (Object[])ThaumcraftWands.getRecipe(rod, cap, true));
            }
        }
    }

    private static int getVisCost(String rod, String cap, boolean sceptre) {
        int cost = 0;
        int capcost = ((WandCap)WandCap.caps.get(cap)).getCraftCost();
        int rodcost = ThaumcraftWands.getWandRod(rod).getCraftCost();
        int rodmod = 5;
        float sceptremod = 2.0f;
        if (cap == "cloth") {
            capcost = 4;
        }
        if (cap == "shadowcloth") {
            capcost = 6;
        }
        if (cap == "blood_iron" || cap == "crimsoncloth" || cap == "thauminite") {
            capcost = 7;
        }
        if (rod == "BREAD") {
            rodcost = 3;
        }
        if (rod == "livingwood" || rod == "dreamwood" || rod == "witchwood") {
            rodcost = 9;
        }
        if (rodcost <= 3 || rod == "AMBER" || rod == "BREAD") {
            int n = cost = rod == "wood" ? 0 : 20;
        }
        if (rodcost == 6 || rod == "AMBER_staff") {
            cost = rod == "tbthaumium" ? 60 : 50;
            rodmod = 10;
            sceptremod = 1.5f;
        }
        if (rodcost == 8 || rodcost == 9) {
            cost = 75;
            rodmod = 15;
            sceptremod = 1.4f;
        }
        if (rodcost == 10) {
            cost = 250;
            rodmod = 25;
            sceptremod = 1.2f;
        }
        if (rodcost == 12 || rodcost == 14 || rodcost == 15) {
            cost = 125;
            rodmod = 15;
            sceptremod = 1.5f;
        }
        if (rod == "bloodwood" || rodcost == 24 || rodcost == 25) {
            cost = 150;
            rodmod = rod == "bloodwood" ? 20 : 15;
            sceptremod = 1.2f;
        }
        if (rodcost == 16) {
            cost = rod == "warpwood" ? 135 : 130;
            rodmod = 15;
            sceptremod = 1.2f;
        }
        if (rodcost == 20) {
            cost = 200;
            rodmod = 25;
            sceptremod = 1.2f;
        }
        if (rodcost >= 27) {
            cost = 175;
            rodmod = 20;
            sceptremod = 1.6f;
        }
        for (int i = 1; i != 10 && i != capcost; ++i) {
            if (i == 8) continue;
            cost += rodmod;
        }
        if (rod == "wood" && cap == "iron" && sceptre) {
            return 10;
        }
        if (cap == "terrasteel") {
            return ThaumcraftWands.getVisCost(rod, "void", sceptre) / 6;
        }
        if (sceptre) {
            return Math.round((float)cost * sceptremod);
        }
        return cost;
    }

    public static Object[] getRecipe(String rod, String cap, boolean sceptre) {
        ItemStack core = rod.contains("_staff") ? ((WandRod)StaffRod.rods.get(rod)).getItem() : (rod == "wood" && Loader.isModLoaded((String)"Forestry") ? GT_ModHandler.getModItem((String)"Forestry", (String)"oakStick", (long)1L) : ((WandRod)WandRod.rods.get(rod)).getItem());
        if (!sceptre) {
            return new Object[]{"MSC", "SRS", "CSM", Character.valueOf('M'), ThaumcraftWands.getConductorfromName(rod), Character.valueOf('C'), ((WandCap)WandCap.caps.get(cap)).getItem(), Character.valueOf('S'), ThaumcraftWands.getScrewfromName(rod), Character.valueOf('R'), core};
        }
        return new Object[]{"MCP", "SRC", "CSM", Character.valueOf('M'), ThaumcraftWands.getConductorfromName(rod), Character.valueOf('C'), ((WandCap)WandCap.caps.get(cap)).getItem(), Character.valueOf('P'), GT_ModHandler.getModItem((String)"Thaumcraft", (String)"ItemResource", (long)1L, (int)15), Character.valueOf('S'), ThaumcraftWands.getScrewfromName(rod), Character.valueOf('R'), core};
    }

    private static String getScrewfromName(String s) {
        if (s == "wood") {
            return screw[0];
        }
        if (s.contains("_staff")) {
            int capacity = ThaumcraftWands.getWandRod(s).getCapacity();
            if (capacity <= 25) {
                return screw[1];
            }
            if (capacity == 125) {
                return screw[2];
            }
            if (capacity == 175 || capacity == 200 || capacity == 500) {
                return screw[3];
            }
            if (s == "primal_staff") {
                return screw[5];
            }
            return screw[4];
        }
        int capacity = ThaumcraftWands.getWandRod(s).getCapacity();
        if (capacity <= 50) {
            return screw[1];
        }
        if (capacity <= 80) {
            return screw[2];
        }
        if (capacity == 1000) {
            return screw[6];
        }
        return screw[3];
    }

    private static ItemStack getConductorfromName(String s) {
        if (s == "wood") {
            return conductor[0];
        }
        if (s.contains("_staff")) {
            int capacity = ThaumcraftWands.getWandRod(s).getCapacity();
            if (capacity <= 25) {
                return conductor[1];
            }
            if (capacity == 125) {
                return conductor[2];
            }
            if (capacity == 175 || capacity == 200 || capacity == 500) {
                return conductor[3];
            }
            return conductor[4];
        }
        int capacity = ThaumcraftWands.getWandRod(s).getCapacity();
        if (capacity <= 50) {
            return conductor[1];
        }
        if (capacity <= 80) {
            return conductor[2];
        }
        if (capacity == 1000) {
            return conductor[5];
        }
        return conductor[3];
    }

    private static WandRod getWandRod(String s) {
        if (s.contains("_staff")) {
            return (WandRod)StaffRod.rods.get(s);
        }
        return (WandRod)WandRod.rods.get(s);
    }

    private static void makeCap(ItemStack stack, String name, float discount, int cost, ResourceLocation res) {
        WandCap c = new WandCap(name, discount, stack, cost);
        c.setTexture(res);
        WandCap.caps.put(name, c);
    }

    private static void makeCap(ItemStack stack, String name, float discount, List<Aspect> list, float discountSpecial, int cost, ResourceLocation res) {
        WandCap c = new WandCap(name, discount, list, discountSpecial, stack, cost);
        c.setTexture(res);
        WandCap.caps.put(name, c);
    }

    private static void removeTCWands() {
        ArrayList l1 = new ArrayList();
        try {
            Field f = ThaumcraftApi.class.getDeclaredField("craftingRecipes");
            f.setAccessible(true);
            ArrayList l2 = (ArrayList)f.get(ArrayList.class);
            for (Object r : l2) {
                if (r instanceof ArcaneWandRecipe || r instanceof ArcaneSceptreRecipe) continue;
                l1.add(r);
            }
            f.set(ArrayList.class, l1);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

