/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.tcwands.api;

import gregtech.api.enums.Tier;
import gregtech.api.util.GT_ModHandler;
import java.util.function.Supplier;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public enum GTTier {
    LV(0, () -> new ItemStack(Blocks.field_150350_a)),
    MV(1, () -> GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.nagaScale", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151015_O))),
    HV(2, () -> GT_ModHandler.getModItem((String)"dreamcraft", (String)"item.LichBone", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151172_bF))),
    EV(3, () -> GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.fieryBlood", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151174_bG))),
    IV(4, () -> GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.fieryTears", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151170_bI))),
    LUV(5, () -> GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.carminite", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151034_e))),
    ZPM(6, () -> GT_ModHandler.getModItem((String)"TwilightForest", (String)"item.carminite", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151034_e))),
    UV(7, () -> GT_ModHandler.getModItem((String)"dreamcraft", (String)"item.SnowQueenBlood", (long)1L, (int)0, (ItemStack)new ItemStack(Items.field_151105_aU)));

    private static final GTTier[] tiers;
    private int index;
    private Supplier<ItemStack> wandConductorSupplier;

    private GTTier(int index, Supplier<ItemStack> wandConductorSupplier) {
        this.index = index;
        this.wandConductorSupplier = wandConductorSupplier;
    }

    public static void init() {
        for (GTTier tier : GTTier.values()) {
            ItemStack conductor = tier.wandConductorSupplier.get();
            tier.wandConductorSupplier = () -> conductor;
        }
    }

    public int getIndex() {
        return this.index;
    }

    public Tier getGregTier() {
        return Tier.ELECTRIC[this.getIndex() + 1];
    }

    public ItemStack getConductor() {
        return this.wandConductorSupplier.get();
    }

    public GTTier nextTier() {
        if (this.getIndex() >= tiers.length - 1) {
            return this;
        }
        return tiers[this.getIndex() + 1];
    }

    static {
        tiers = new GTTier[GTTier.values().length];
        for (int i = 0; i < GTTier.values().length; ++i) {
            GTTier tier;
            GTTier.tiers[tier.getIndex()] = tier = GTTier.values()[i];
        }
    }
}

