/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modcustomdrops;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modcustomdrops.CustomDrops;
import com.dreammaster.modcustomdrops.CustomDropsFactory;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.auxiliary.PlayerChatHelper;
import eu.usrv.yamcore.persisteddata.PersistedDataBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import thaumcraft.common.lib.FakeThaumcraftPlayer;

public class CustomDropsHandler {
    private LogHelper _mLogger = MainRegistry.Logger;
    private String _mConfigFileName;
    private CustomDropsFactory _mCfF = new CustomDropsFactory();
    private CustomDrops _mCustomDrops;
    private PersistedDataBase _mPersistedDB;
    private List<UUID> _mDeathDebugPlayers;

    public CustomDropsHandler(File pConfigBaseDir) {
        this._mConfigFileName = String.format("config/%s/CustomDrops.xml", "GTNewHorizons");
        this._mDeathDebugPlayers = new ArrayList<UUID>();
    }

    public void InitSampleConfig() {
        CustomDrops.CustomDrop.Drop pigDiamondLimitedDrop = this._mCfF.createDrop("minecraft:diamond", "sample_Pig_DiamondDrop", "{Lore: [\"Oh, shiny!\"]}", 1, false, 100, 5);
        CustomDrops.CustomDrop.Drop pigCakeUnlimitedDrop = this._mCfF.createDrop("minecraft:cake", "sample_Pig_CakeDrop", 1, false, 100, 0);
        CustomDrops.CustomDrop.Drop pigRandomCharcoalDrop = this._mCfF.createDrop("minecraft:coal:1", "sample_Pig_CharcoalDrop", 5, true, 100, 0);
        CustomDrops.CustomDrop pigDrop = this._mCfF.createCustomDropEntry("eu.usrv.dummyEntity.ImbaSampleDragon");
        pigDrop.getDrops().add(pigDiamondLimitedDrop);
        pigDrop.getDrops().add(pigCakeUnlimitedDrop);
        pigDrop.getDrops().add(pigRandomCharcoalDrop);
        this._mCustomDrops = new CustomDrops();
        this._mCustomDrops.getCustomDrops().add(pigDrop);
    }

    public boolean SaveCustomDrops() {
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomDrops.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mCustomDrops, (OutputStream)new FileOutputStream(this._mConfigFileName, false));
            this._mLogger.debug((Object)"Config file written");
            return true;
        }
        catch (Exception e) {
            this._mLogger.error((Object)"Unable to create new CustomDrops.xml. What did you do??");
            e.printStackTrace();
            return false;
        }
    }

    public void LoadConfig() {
        this._mLogger.debug((Object)"CustomDrops entering state: LOAD CONFIG");
        File tConfigFile = new File(this._mConfigFileName);
        if (!tConfigFile.exists()) {
            this._mLogger.debug((Object)"CustomDrops Config file not found, assuming first-start. Creating default one");
            this.InitSampleConfig();
            this.SaveCustomDrops();
        }
        if (!this.ReloadCustomDrops()) {
            this._mLogger.warn((Object)"Configuration File seems to be damaged, loading does-nothing-evil default config. You should fix your file and reload it");
            MainRegistry.AddLoginError("[CustomDrops] Config file not loaded due errors");
            this.InitSampleConfig();
        }
    }

    private boolean VerifyConfig(CustomDrops pDropListToCheck) {
        boolean tSuccess = true;
        for (CustomDrops.CustomDrop X : pDropListToCheck.getCustomDrops()) {
            for (CustomDrops.CustomDrop.Drop Y : X.getDrops()) {
                if (ItemDescriptor.fromString((String)Y.getItemName()) == null) {
                    this._mLogger.error((Object)String.format("In ItemDropID: [%s], can't find item [%s]", Y.getIdentifier(), Y.getItemName()));
                    tSuccess = false;
                }
                if (Y.mTag == null || Y.mTag.isEmpty()) continue;
                try {
                    NBTTagCompound tNBT = (NBTTagCompound)JsonToNBT.func_150315_a((String)Y.mTag);
                    if (tNBT != null) continue;
                    tSuccess = false;
                }
                catch (Exception e) {
                    this._mLogger.error((Object)String.format("In ItemDropID: [%s], NBTTag is invalid", Y.getIdentifier()));
                    tSuccess = false;
                }
            }
        }
        return tSuccess;
    }

    public boolean ReloadCustomDrops() {
        boolean tResult = false;
        this._mLogger.debug((Object)"CustomDropsHandler will now try to load its configuration");
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{CustomDrops.class});
            File tConfigFile = new File(this._mConfigFileName);
            Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
            CustomDrops tNewItemCollection = (CustomDrops)jaxUnmarsh.unmarshal(tConfigFile);
            this._mLogger.debug((Object)"Config file has been loaded. Entering Verify state");
            if (!this.VerifyConfig(tNewItemCollection)) {
                this._mLogger.error((Object)"New config will NOT be activated. Please check your error-log and try again");
                tResult = false;
            } else {
                this._mCustomDrops = tNewItemCollection;
                tResult = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tResult;
    }

    @SubscribeEvent
    public void onMobDrops(LivingDropsEvent pEvent) {
        try {
            UUID tUUID;
            EntityLivingBase tEntity = pEvent.entityLiving;
            EntityPlayer tEP = null;
            if (pEvent.source.func_76346_g() != null && pEvent.source.func_76346_g() instanceof EntityPlayer && this._mDeathDebugPlayers.contains(tUUID = (tEP = (EntityPlayer)pEvent.source.func_76346_g()).func_110124_au())) {
                PlayerChatHelper.SendInfo((EntityPlayer)tEP, (String)String.format("Killed entity: [%s]", tEntity.getClass().getName()));
            }
            if (tEP == null) {
                return;
            }
            if (tEP instanceof FakePlayer) {
                return;
            }
            if (Loader.isModLoaded((String)"Thaumcraft") && tEP instanceof FakeThaumcraftPlayer) {
                return;
            }
            CustomDrops.CustomDrop tCustomDrop = this._mCustomDrops.FindDropEntry(tEntity);
            if (tCustomDrop == null) {
                return;
            }
            this.HandleCustomDrops(tCustomDrop, tEntity, tEP, pEvent.drops);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void HandleCustomDrops(CustomDrops.CustomDrop tCustomDrop, EntityLivingBase tEntity, EntityPlayer tEP, ArrayList<EntityItem> pDropList) {
        try {
            if (this._mPersistedDB == null) {
                this._mPersistedDB = new PersistedDataBase(DimensionManager.getCurrentSaveRootDirectory(), "CustomDrops.dat", "GTNewHorizons");
            }
            for (CustomDrops.CustomDrop.Drop dr : tCustomDrop.getDrops()) {
                ItemStack tDropStack;
                String tDropID = dr.getIdentifier();
                String tUserID = tEP.func_110124_au().toString();
                String tFinalDropID = String.format("%s.%s", tUserID, tDropID);
                int tFinalAmount = dr.getAmount();
                if (MainRegistry.Rnd.nextInt(100) > dr.getChance()) continue;
                if (dr.getLimitedDropCount() > 0) {
                    int tDropCount = this._mPersistedDB.getValueAsInt(tFinalDropID, 0);
                    if (tDropCount >= dr.getLimitedDropCount()) continue;
                    this._mPersistedDB.setValue(tFinalDropID, ++tDropCount);
                }
                if (dr.getIsRandomAmount()) {
                    tFinalAmount = Math.max(1, MainRegistry.Rnd.nextInt(dr.getAmount() + 1));
                }
                if ((tDropStack = ItemDescriptor.fromString((String)dr.getItemName()).getItemStackwNBT(tFinalAmount, dr.mTag)) == null) {
                    this._mLogger.error((Object)String.format("CustomDrop ID %s failed to drop", dr.getIdentifier()));
                    continue;
                }
                EntityItem tDropEntity = new EntityItem(tEntity.field_70170_p, tEntity.field_70165_t, tEntity.field_70163_u, tEntity.field_70161_v, tDropStack);
                pDropList.add(tDropEntity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void toggleDeathInfoForPlayer(EntityPlayer pEP) {
        UUID tUUID = pEP.func_110124_au();
        if (this._mDeathDebugPlayers.contains(tUUID)) {
            this._mDeathDebugPlayers.remove(tUUID);
            PlayerChatHelper.SendInfo((EntityPlayer)pEP, (String)"Death-Debug is now diabled");
        } else {
            this._mDeathDebugPlayers.add(tUUID);
            PlayerChatHelper.SendInfo((EntityPlayer)pEP, (String)"Death-Debug is now enabled");
        }
    }
}

