/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.modhazardousitems;

import com.dreammaster.main.MainRegistry;
import com.dreammaster.modhazardousitems.HazardDamageSources;
import com.dreammaster.modhazardousitems.HazardousItems;
import com.dreammaster.modhazardousitems.HazardousObjectFactory;
import com.dreammaster.modhazardousitems.IDamageEffectContainer;
import com.dreammaster.modhazardousitems.cause.HazardCause;
import com.google.common.collect.EvictingQueue;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.registry.GameRegistry;
import eu.usrv.yamcore.auxiliary.ItemDescriptor;
import eu.usrv.yamcore.auxiliary.LogHelper;
import eu.usrv.yamcore.gameregistry.PotionHelper;
import gregtech.api.util.GT_Utility;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Random;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.util.MathHelper;
import net.minecraftforge.fluids.IFluidContainerItem;

public class HazardousItemsHandler {
    private final Random _mRnd = new Random();
    private final LogHelper _mLogger = MainRegistry.Logger;
    private HazardousItems _mHazardItemsCollection;
    private final String _mConfigFileName;
    private final HazardousObjectFactory _mHazFactory = new HazardousObjectFactory();
    private boolean IsConfigDirty = false;
    private boolean _mRunProfiler = true;
    private final EvictingQueue<Long> _mTimingQueue = EvictingQueue.create((int)20);
    private long _mLastAverage = 0L;
    private long ticks = 0L;
    private int touchBlockChance = 20;
    private int inventoryCheckPeriod = 60;

    public HazardousItemsHandler() {
        this._mConfigFileName = String.format("config/%s/HazardousItems.xml", "GTNewHorizons");
    }

    public boolean HasConfigChanged() {
        return this.IsConfigDirty;
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        if (GT_Utility.isWearingFullGasHazmat((EntityLivingBase)event.player)) {
            return;
        }
        long tStart = System.currentTimeMillis();
        this.CheckInventoryForItems(event.player);
        this.CheckPlayerTouchesBlock(event.player);
        ++this.ticks;
        long tEnd = System.currentTimeMillis();
        this._mTimingQueue.add((Object)(tEnd - tStart));
        if (tEnd + 1000L > this._mLastAverage && this._mRunProfiler) {
            if (this.getAverageTiming() > 250L) {
                if (this.touchBlockChance > 500) {
                    this._mLogger.error((Object)"Execution chance is over 500. Not going to increase wait-timer anymore. if it still lags, contact me and we'll find another way");
                    this._mRunProfiler = false;
                    this._mLogger.error((Object)"HazardousItems-Profiler is now disabled");
                    return;
                }
                this._mLogger.warn((Object)"WARNING: The HazardousItems loop has an average timing of > 250ms, which may cause lag. Increasing wait-time between inventory-scan calls");
                ++this.touchBlockChance;
                ++this.inventoryCheckPeriod;
                this._mTimingQueue.clear();
            } else {
                this._mLastAverage = System.currentTimeMillis();
            }
        }
    }

    private long getAverageTiming() {
        if (this._mTimingQueue.isEmpty()) {
            return 0L;
        }
        if (this._mTimingQueue.remainingCapacity() != 0) {
            return 0L;
        }
        long sum = 0L;
        Iterator iterator = this._mTimingQueue.iterator();
        while (iterator.hasNext()) {
            long time = (Long)iterator.next();
            sum += time;
        }
        return sum / (long)this._mTimingQueue.size();
    }

    public void InitSampleConfig() {
        HazardousItems.ItmDamageEffect tFireEffect = this._mHazFactory.createDamageEffect(Float.valueOf(0.5f), "inFire");
        HazardousItems.ItmPotionEffect tPoisonPotion = this._mHazFactory.createPotionEffect(100, Potion.field_76436_u.field_76415_H, 1);
        HazardousItems.HazardousItem tHazItem = this._mHazFactory.createHazardousItemsHazardousItem("tfarcenim:stone", true, true, true);
        HazardousItems.HazardousFluid tHazFluid = this._mHazFactory.createHazardousFluid("tfarcenim:water", true, true, true);
        tHazItem.getDamageEffects().add(tFireEffect);
        tHazItem.getPotionEffects().add(tPoisonPotion);
        tHazFluid.getDamageEffects().add(tFireEffect);
        tHazFluid.getPotionEffects().add(tPoisonPotion);
        this._mHazardItemsCollection = new HazardousItems();
        this._mHazardItemsCollection.getHazardousItems().add(tHazItem);
        this._mHazardItemsCollection.getHazardousFluids().add(tHazFluid);
    }

    public boolean SaveHazardousItems() {
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{HazardousItems.class});
            Marshaller jaxMarsh = tJaxbCtx.createMarshaller();
            jaxMarsh.setProperty("jaxb.formatted.output", (Object)true);
            jaxMarsh.marshal((Object)this._mHazardItemsCollection, (OutputStream)new FileOutputStream(this._mConfigFileName, false));
            this._mLogger.debug((Object)"Config file written");
            this.IsConfigDirty = false;
            return true;
        }
        catch (Exception e) {
            this._mLogger.error((Object)"Unable to create new HazardousItems.xml. What did you do??");
            e.printStackTrace();
            return false;
        }
    }

    public void LoadConfig() {
        this._mLogger.debug((Object)"HazardousItems entering state: LOAD CONFIG");
        File tConfigFile = new File(this._mConfigFileName);
        if (!tConfigFile.exists()) {
            this._mLogger.debug((Object)"HazardousItems Config file not found, assuming first-start. Creating default one");
            this.InitSampleConfig();
            this.SaveHazardousItems();
        }
        if (!this.ReloadHazardousItems()) {
            this._mLogger.warn((Object)"Configuration File seems to be damaged, loading does-nothing-evil default config. You should fix your file and reload it");
            MainRegistry.AddLoginError("[HazardousItems] Config file not loaded due errors");
            this.InitSampleConfig();
        }
    }

    public boolean ReloadHazardousItems() {
        boolean tResult = false;
        this._mLogger.debug((Object)"HazardousItemsHandler will now try to load it's configuration");
        try {
            JAXBContext tJaxbCtx = JAXBContext.newInstance((Class[])new Class[]{HazardousItems.class});
            File tConfigFile = new File(this._mConfigFileName);
            Unmarshaller jaxUnmarsh = tJaxbCtx.createUnmarshaller();
            HazardousItems tNewItemCollection = (HazardousItems)jaxUnmarsh.unmarshal(tConfigFile);
            this._mLogger.debug((Object)"Config file has been loaded. Entering Verify state");
            if (this.VerifyConfiguredDamageEffects(tNewItemCollection) && this.VerifyConfiguredPotionEffects(tNewItemCollection)) {
                this._mHazardItemsCollection = tNewItemCollection;
                this.IsConfigDirty = false;
                tResult = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return tResult;
    }

    public boolean VerifyConfiguredDamageEffects(HazardousItems pItemCollection) {
        boolean tResult = true;
        for (HazardousItems.HazardousItem hi : pItemCollection.getHazardousItems()) {
            for (HazardousItems.ItmDamageEffect ide : hi.getDamageEffects()) {
                if (HazardDamageSources.isValid(ide.getDamageSource())) continue;
                this._mLogger.warn((Object)String.format("HazardousItem [%s] has invalid DamageSource entry: [%s]", hi.getItemName(), ide.getDamageSource()));
                tResult = false;
            }
        }
        for (HazardousItems.HazardousFluid hf : pItemCollection.getHazardousFluids()) {
            for (HazardousItems.ItmDamageEffect ide : hf.getDamageEffects()) {
                if (HazardDamageSources.isValid(ide.getDamageSource())) continue;
                this._mLogger.warn((Object)String.format("HazardousFluid [%s] has invalid DamageSource entry: [%s]", hf.getFluidName(), ide.getDamageSource()));
                tResult = false;
            }
        }
        return tResult;
    }

    public boolean VerifyConfiguredPotionEffects(HazardousItems pItemCollection) {
        boolean tResult = true;
        for (HazardousItems.HazardousItem hi : pItemCollection.getHazardousItems()) {
            for (HazardousItems.ItmPotionEffect ipe : hi.getPotionEffects()) {
                if (PotionHelper.IsValidPotionID((int)ipe.getId())) continue;
                this._mLogger.warn((Object)String.format("HazardousItem [%s] has invalid PotionID: [%s] (There is no such potion)", hi.getItemName(), ipe.getId()));
                tResult = false;
            }
        }
        for (HazardousItems.HazardousFluid hf : pItemCollection.getHazardousFluids()) {
            for (HazardousItems.ItmPotionEffect ipe : hf.getPotionEffects()) {
                if (PotionHelper.IsValidPotionID((int)ipe.getId())) continue;
                this._mLogger.warn((Object)String.format("HazardousFluid [%s] has invalid PotionID: [%s] (There is no such potion)", hf.getFluidName(), ipe.getId()));
                tResult = false;
            }
        }
        return tResult;
    }

    private void CheckPlayerTouchesBlock(EntityPlayer pPlayer) {
        if (this._mRnd.nextInt(this.touchBlockChance) != 0) {
            return;
        }
        try {
            IDamageEffectContainer hazard;
            int blockX = MathHelper.func_76128_c((double)pPlayer.field_70165_t);
            int blockY = MathHelper.func_76128_c((double)pPlayer.field_70121_D.field_72338_b);
            int blockZ = MathHelper.func_76128_c((double)pPlayer.field_70161_v);
            Block pBlockContact = pPlayer.field_70170_p.func_147439_a(blockX, blockY, blockZ);
            Block pBlockUnderFeet = pPlayer.field_70170_p.func_147439_a(blockX, blockY - 1, blockZ);
            GameRegistry.UniqueIdentifier tUidContact = GameRegistry.findUniqueIdentifierFor((Block)pBlockContact);
            GameRegistry.UniqueIdentifier tUidFeet = GameRegistry.findUniqueIdentifierFor((Block)pBlockUnderFeet);
            if (tUidContact != null && !tUidContact.toString().equals("minecraft:air") && (hazard = this._mHazardItemsCollection.FindHazardousFluidExact(tUidContact.toString())) != null && ((HazardousItems.HazardousFluid)hazard).getCheckContact()) {
                this.doEffects(HazardCause.stepOn(), hazard, pPlayer);
            }
            if (tUidFeet != null && !tUidFeet.toString().equals("minecraft:air") && (hazard = this._mHazardItemsCollection.FindHazardousItemExact(tUidFeet.toString())) != null && ((HazardousItems.HazardousItem)hazard).getCheckContact()) {
                this.doEffects(HazardCause.stepOn(), hazard, pPlayer);
            }
        }
        catch (Exception e) {
            this._mLogger.error("HazardousItemsHandler.CheckPlayerTouchesBlock.error", (Object)"Something bad happend while processing the onPlayerTick event");
            e.printStackTrace();
        }
    }

    private void checkInventoryArray(ItemStack[] pInventory, EntityPlayer pPlayer) {
        if (pInventory == null) {
            return;
        }
        for (ItemStack stack : pInventory) {
            String tCurrIS = "";
            try {
                if (stack == null) continue;
                tCurrIS = ItemDescriptor.fromStack((ItemStack)stack).toString();
                if (stack.func_77973_b() instanceof IFluidContainerItem) {
                    HazardousItems.HazardousFluid hazardFluid = this._mHazardItemsCollection.FindHazardousFluid(stack);
                    if (hazardFluid == null || !hazardFluid.getCheckInventory()) continue;
                    this.doEffects(HazardCause.inventoryItem(stack), hazardFluid, pPlayer);
                    continue;
                }
                if ("tconstruct.smeltery.itemblocks.LavaTankItemBlock".equals(stack.func_77973_b().getClass().getName())) {
                    HazardousItems.HazardousFluid hazardFluid;
                    String tFluidName;
                    NBTTagCompound tFluidCompound;
                    NBTTagCompound tNBT = stack.func_77978_p();
                    if (tNBT == null || !tNBT.func_74764_b("Fluid") || (tFluidCompound = tNBT.func_74775_l("Fluid")) == null || !tFluidCompound.func_74764_b("FluidName") || (tFluidName = tFluidCompound.func_74779_i("FluidName")) == null || tFluidName.isEmpty() || (hazardFluid = this._mHazardItemsCollection.FindHazardousFluidExact(tFluidName)) == null || !hazardFluid.getCheckInventory()) continue;
                    this.doEffects(HazardCause.inventoryItem(stack), hazardFluid, pPlayer);
                    continue;
                }
                HazardousItems.HazardousItem hazardItem = this._mHazardItemsCollection.FindHazardousItem(stack);
                if (hazardItem == null || !hazardItem.getCheckInventory()) continue;
                this.doEffects(HazardCause.inventoryItem(stack), hazardItem, pPlayer);
            }
            catch (Exception e) {
                this._mLogger.debug((Object)String.format("Something weird happend with item %s", tCurrIS));
            }
        }
    }

    private void CheckInventoryForItems(EntityPlayer pPlayer) {
        block8: {
            if (this.ticks % (long)this.inventoryCheckPeriod != 0L) {
                return;
            }
            try {
                this.checkInventoryArray(pPlayer.field_71071_by.field_70462_a, pPlayer);
                if (!Loader.isModLoaded((String)"battlegear2")) break block8;
                Class<?> c = pPlayer.field_71071_by.getClass();
                Field extraInv = null;
                try {
                    extraInv = c.getDeclaredField("extraItems");
                }
                catch (NoSuchFieldException nsfe) {
                    this._mLogger.warn("battlegear.changed.1", (Object)"Seems battlegear has updated/changed. Someone has to fix HazardousItems!");
                }
                if (extraInv == null) {
                    return;
                }
                try {
                    ItemStack[] tExtraInv = (ItemStack[])extraInv.get(pPlayer.field_71071_by);
                    this.checkInventoryArray(tExtraInv, pPlayer);
                }
                catch (Exception ex) {
                    this._mLogger.warn("battlegear.changed.2", (Object)"Seems battlegear has updated/changed. Someone has to fix HazardousItems!");
                }
            }
            catch (Exception e) {
                this._mLogger.error("HazardousItemsHandler.CheckInventoryForItems.error", (Object)"Something bad happend while processing the onPlayerTick event");
                e.printStackTrace();
            }
        }
    }

    private void doEffects(HazardCause cause, IDamageEffectContainer effectContainer, EntityPlayer player) {
        for (HazardousItems.ItmDamageEffect itmDamageEffect : effectContainer.getDamageEffects()) {
            itmDamageEffect.apply(cause, player);
        }
        for (HazardousItems.ItmPotionEffect itmPotionEffect : effectContainer.getPotionEffects()) {
            itmPotionEffect.apply(cause, player);
        }
    }
}

