/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.scripts;

import com.dreammaster.main.MainRegistry;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GT_OreDictUnificator;
import gregtech.common.items.GT_MetaGenerated_Item_01;
import gregtech.common.items.GT_MetaGenerated_Item_02;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public interface IScriptLoader {
    public static final int wildcard = Short.MAX_VALUE;

    public String getScriptName();

    public List<String> getDependencies();

    public void loadRecipes();

    default public boolean addShapedRecipe(ItemStack aOutputStack, Object[] inputs) {
        Object[] slots = new Object[9];
        StringBuilder fullString = new StringBuilder();
        String slotMappings = "abcdefghi";
        try {
            for (int i = 0; i < 9; ++i) {
                ItemStack itemStack;
                Object o = inputs[i];
                if (o instanceof ItemStack) {
                    itemStack = ((ItemStack)o).func_77946_l();
                    itemStack.field_77994_a = 1;
                    slots[i] = itemStack.func_77946_l();
                    fullString.append(slotMappings.charAt(i));
                    continue;
                }
                if (o instanceof Item) {
                    itemStack = new ItemStack((Item)o, 1);
                    slots[i] = itemStack.func_77946_l();
                    fullString.append(slotMappings.charAt(i));
                    continue;
                }
                if (o instanceof Block) {
                    itemStack = new ItemStack((Block)o, 1);
                    slots[i] = itemStack.func_77946_l();
                    fullString.append(slotMappings.charAt(i));
                    continue;
                }
                if (o instanceof String) {
                    slots[i] = o;
                    fullString.append(slotMappings.charAt(i));
                    continue;
                }
                if (o instanceof ItemData) {
                    ItemData data = (ItemData)o;
                    ItemStack itemStack2 = GT_OreDictUnificator.get((OrePrefixes)data.mPrefix, (Object)data.mMaterial.mMaterial, (long)1L);
                    if (itemStack2 == null) {
                        throw new NullPointerException("bad item passed in the recipe");
                    }
                    slots[i] = itemStack2;
                    fullString.append(slotMappings.charAt(i));
                    continue;
                }
                if (o == null) {
                    slots[i] = null;
                    fullString.append(" ");
                    continue;
                }
                slots[i] = null;
                throw new NullPointerException("bad recipe generated");
            }
            String aRow1 = fullString.substring(0, 3);
            String aRow2 = fullString.substring(3, 6);
            String aRow3 = fullString.substring(6, 9);
            String[] recipeRows = new String[]{aRow1, aRow2, aRow3};
            Object[] recipeInputs = new Object[19];
            recipeInputs[0] = recipeRows;
            int aIndex = 0;
            for (int u = 1; u < 20 && aIndex != 9; ++aIndex, u += 2) {
                if (fullString.charAt(aIndex) == ' ') continue;
                recipeInputs[u] = Character.valueOf(fullString.charAt(aIndex));
                recipeInputs[u + 1] = slots[aIndex];
            }
            recipeInputs = IScriptLoader.removeNulls(recipeInputs);
            ShapedOreRecipe aRecipe = new ShapedOreRecipe(aOutputStack, recipeInputs);
            GameRegistry.addRecipe((IRecipe)aRecipe);
        }
        catch (Exception e) {
            MainRegistry.Logger.error((Object)"a recipe went wrong:");
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Object[] removeNulls(Object[] v) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(v));
        list.removeAll(Collections.singleton(null));
        return list.toArray(new Object[0]);
    }

    default public ItemStack getMeta02(int meta) {
        return new ItemStack((Item)GT_MetaGenerated_Item_02.INSTANCE, 1, meta);
    }

    default public ItemStack getMeta01(int meta) {
        return new ItemStack((Item)GT_MetaGenerated_Item_01.INSTANCE, 1, meta);
    }

    default public boolean isScriptLoadable() {
        for (String dep : this.getDependencies()) {
            if (Loader.isModLoaded((String)dep)) continue;
            return false;
        }
        return true;
    }
}

