/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.tinkersConstruct;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import tconstruct.library.crafting.Smeltery;

public class MeltingRecipeAdder {
    private final Consumer<ItemStack> addMelting;
    private final Block renderBlock;
    private final int renderBlockMeta;
    private final int meltingTemperature;
    private final String fluidName;

    MeltingRecipeAdder(Block renderBlock, int renderBlockMeta, int meltingTemperature, String fluidName, int amount) {
        this.renderBlock = renderBlock;
        this.renderBlockMeta = renderBlockMeta;
        this.meltingTemperature = meltingTemperature;
        this.fluidName = fluidName;
        this.addMelting = itemStack -> Smeltery.addMelting((ItemStack)itemStack, (Block)renderBlock, (int)renderBlockMeta, (int)meltingTemperature, (FluidStack)FluidRegistry.getFluidStack((String)fluidName, (int)amount));
    }

    public MeltingRecipeAdder withAmount(int newAmount) {
        return new MeltingRecipeAdder(this.renderBlock, this.renderBlockMeta, this.meltingTemperature, this.fluidName, newAmount);
    }

    public MeltingRecipeAdder add(ItemStack itemStack) {
        this.addMelting.accept(itemStack);
        return this;
    }

    public MeltingRecipeAdder add(Stream<ItemStack> itemStackStream) {
        itemStackStream.forEach(this.addMelting);
        return this;
    }

    public MeltingRecipeAdder add(ItemStack ... itemStacks) {
        this.add(Arrays.stream(itemStacks));
        return this;
    }
}

