/*
 * Decompiled with CFR 0.152.
 */
package com.dreammaster.tinkersConstruct;

import com.dreammaster.main.NHItems;
import com.dreammaster.mantle.BookLoader;
import com.dreammaster.scripts.IScriptLoader;
import com.dreammaster.tinkersConstruct.SmelteryFluidTypes;
import com.dreammaster.tinkersConstruct.worldgen.ZincGravelOre;
import com.dreammaster.tinkersConstruct.worldgen.ZincGravelOreItem;
import com.dreammaster.tinkersConstruct.worldgen.ZincGravelWorldgen;
import com.gtnewhorizons.postea.api.BlockReplacementManager;
import com.gtnewhorizons.postea.api.ItemStackReplacementManager;
import com.gtnewhorizons.postea.api.TileEntityReplacementManager;
import com.gtnewhorizons.postea.utility.BlockConversionInfo;
import cpw.mods.fml.common.registry.GameRegistry;
import gregtech.api.enums.Materials;
import gregtech.api.enums.Mods;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

public class TiCoLoader {
    public static void doPreInitialization() {
        TiCoLoader.registerZincGravelOre();
    }

    private static void registerZincGravelOre() {
        NHItems.ZINC_GRAVEL_ORE = new ZincGravelOre().func_149663_c("block.ore.gravel.zinc");
        NHItems.ZINC_GRAVEL_ORE.setHarvestLevel("shovel", 1, 0);
        GameRegistry.registerBlock((Block)NHItems.ZINC_GRAVEL_ORE, ZincGravelOreItem.class, (String)"ZincGravelOre");
        OreDictionary.registerOre((String)"oreZinc", (ItemStack)new ItemStack(NHItems.ZINC_GRAVEL_ORE, 1, 0));
    }

    public static void doInitialization() {
        TiCoLoader.registerZincGravelOreWorldGen();
    }

    private static void registerZincGravelOreWorldGen() {
        MinecraftForge.TERRAIN_GEN_BUS.register((Object)new ZincGravelWorldgen());
    }

    public static void doPostInitialization() {
        TiCoLoader.addTiCoManuals();
        TiCoLoader.registerAluminumBrassPosteaTransformers();
        TiCoLoader.registerGravelOrePosteaTransformers();
    }

    private static void addTiCoManuals() {
        TiCoLoader.addTiCoManual("firstday", "tconstruct.manual.beginner", "manual1.tooltip", "tinker:tinkerbook_diary");
        TiCoLoader.addTiCoManual("materials", "tconstruct.manual.toolstation", "manual2.tooltip", "tinker:tinkerbook_toolstation");
        TiCoLoader.addTiCoManual("smeltery", "tconstruct.manual.smeltery", "manual3.tooltip", "tinker:tinkerbook_smeltery");
        TiCoLoader.addTiCoManual("diary", "tconstruct.manual.diary", "manual4.tooltip", "tinker:tinkerbook_blue");
        TiCoLoader.addTiCoManual("weaponry", "tconstruct.manual.weaponry", "manual5.tooltip", "tinker:tinkerbook_green");
    }

    private static void addTiCoManual(String bookName, String unlocalizedName, String tooltip, String itemImage) {
        BookLoader.of(unlocalizedName, Mods.TinkerConstruct.ID, "/assets/dreamcraft/tinker/manuals/" + bookName + ".xml").setTooltip(tooltip).setItemImage(itemImage).makeTranslatable().addToBookDataStore();
    }

    private static void registerAluminumBrassPosteaTransformers() {
        TiCoLoader.convertAluminumBrassBlock();
        TiCoLoader.convertAluminumBrassItems();
        TiCoLoader.convertMoltenAluminumBrassInSmeltery();
        TiCoLoader.convertAluminumBrassSingularity();
    }

    private static void convertAluminumBrassBlock() {
        String targetBlock = "TConstruct:MetalBlock";
        ItemStack brassBlock = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.block, (Object)Materials.Brass, (long)1L);
        int brassBlockMeta = Items.field_151008_G.getDamage(brassBlock);
        BlockReplacementManager.addBlockReplacement((String)targetBlock, (blockConversionInfoOld, world) -> {
            if (blockConversionInfoOld.metadata == 7) {
                BlockConversionInfo blockConversionInfoNew = new BlockConversionInfo();
                blockConversionInfoNew.blockID = Item.func_150891_b((Item)brassBlock.func_77973_b());
                blockConversionInfoNew.metadata = brassBlockMeta;
                return blockConversionInfoNew;
            }
            return null;
        });
        ItemStackReplacementManager.addItemReplacement((String)targetBlock, tag -> {
            if (tag.func_74765_d("Damage") == 7) {
                tag.func_74777_a("id", (short)Item.func_150891_b((Item)brassBlock.func_77973_b()));
                tag.func_74777_a("Damage", (short)brassBlockMeta);
                return tag;
            }
            return tag;
        });
    }

    private static void convertAluminumBrassItems() {
        ItemStack brassIngot = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.ingot, (Object)Materials.Brass, (long)1L);
        ItemStack brassNugget = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.nugget, (Object)Materials.Brass, (long)1L);
        ItemStack brassDust = GTOreDictUnificator.get((OrePrefixes)OrePrefixes.dust, (Object)Materials.Brass, (long)1L);
        ItemStackReplacementManager.addItemReplacement((String)"TConstruct:materials", tag -> {
            switch (tag.func_74765_d("Damage")) {
                case 14: {
                    tag.func_74777_a("id", (short)Item.func_150891_b((Item)brassIngot.func_77973_b()));
                    tag.func_74777_a("Damage", (short)Items.field_151008_G.getDamage(brassIngot));
                    break;
                }
                case 24: {
                    tag.func_74777_a("id", (short)Item.func_150891_b((Item)brassNugget.func_77973_b()));
                    tag.func_74777_a("Damage", (short)Items.field_151008_G.getDamage(brassNugget));
                    break;
                }
                case 42: {
                    tag.func_74777_a("id", (short)Item.func_150891_b((Item)brassDust.func_77973_b()));
                    tag.func_74777_a("Damage", (short)Items.field_151008_G.getDamage(brassDust));
                }
            }
            return tag;
        });
    }

    private static void convertMoltenAluminumBrassInSmeltery() {
        TileEntityReplacementManager.tileEntityTransformer((String)"TConstruct.Smeltery", (tags, world) -> {
            NBTTagList liquidTag = tags.func_150295_c("Liquids", 10);
            for (int i = 0; i < liquidTag.func_74745_c(); ++i) {
                NBTTagCompound nbt = liquidTag.func_150305_b(i);
                if (!"aluminumbrass.molten".equals(nbt.func_74779_i("FluidName"))) continue;
                nbt.func_74778_a("FluidName", SmelteryFluidTypes.getMoltenPatternFluidName());
            }
            return null;
        });
    }

    private static void convertAluminumBrassSingularity() {
        ItemStack roseGoldSingularity = GTModHandler.getModItem((String)Mods.UniversalSingularities.ID, (String)"universal.general.singularity", (long)1L, (int)32, (ItemStack)IScriptLoader.missing);
        ItemStackReplacementManager.addItemReplacement((String)"universalsingularities:universal.tinkersConstruct.singularity", tag -> {
            if (tag.func_74765_d("Damage") == 0) {
                tag.func_74777_a("id", (short)Item.func_150891_b((Item)roseGoldSingularity.func_77973_b()));
                tag.func_74777_a("Damage", (short)roseGoldSingularity.func_77960_j());
                return tag;
            }
            return tag;
        });
    }

    private static void registerGravelOrePosteaTransformers() {
        String targetBlock = "TConstruct:GravelOre";
        BlockReplacementManager.addBlockReplacement((String)targetBlock, (blockConversionInfoOld, world) -> {
            BlockConversionInfo blockConversionInfoNew = new BlockConversionInfo();
            blockConversionInfoNew.blockID = Block.func_149682_b((Block)NHItems.ZINC_GRAVEL_ORE);
            blockConversionInfoNew.metadata = 0;
            return blockConversionInfoNew;
        });
        ItemStackReplacementManager.addItemReplacement((String)targetBlock, tag -> {
            tag.func_74777_a("id", (short)Block.func_149682_b((Block)NHItems.ZINC_GRAVEL_ORE));
            tag.func_74777_a("Damage", (short)0);
            return tag;
        });
    }
}

