/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;

public class BlobPopulatorSpikes
extends BlobPopulator {
    private Block block;
    private IRandomAmount amountGen = IRandomAmount.exact;
    private byte minAmount;
    private byte maxAmount;
    private byte maxOffsetFromCenter;

    public BlobPopulatorSpikes(int weight) {
        super(weight);
    }

    public BlobPopulatorSpikes block(Block block) {
        this.block = block;
        return this;
    }

    public BlobPopulatorSpikes amount(IRandomAmount amountGen, int minAmount, int maxAmount) {
        this.amountGen = amountGen;
        this.minAmount = (byte)minAmount;
        this.maxAmount = (byte)maxAmount;
        return this;
    }

    public BlobPopulatorSpikes maxOffset(int maxOffsetFromCenter) {
        this.maxOffsetFromCenter = (byte)maxOffsetFromCenter;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        int amount = this.amountGen.generate(rand, this.minAmount, this.maxAmount);
        block0: for (int a = 0; a < amount; ++a) {
            for (int attempt = 0; attempt < 10; ++attempt) {
                int z;
                Vec3 vec = DragonUtil.getRandomVector(rand);
                int x = this.maxOffsetFromCenter == 0 ? 0 : rand.nextInt(this.maxOffsetFromCenter * 2) - this.maxOffsetFromCenter;
                int y = this.maxOffsetFromCenter == 0 ? 0 : rand.nextInt(this.maxOffsetFromCenter * 2) - this.maxOffsetFromCenter;
                int n = z = this.maxOffsetFromCenter == 0 ? 0 : rand.nextInt(this.maxOffsetFromCenter * 2) - this.maxOffsetFromCenter;
                if (this.genSpike(gen, x, y, z, vec)) continue block0;
            }
        }
    }

    private boolean genSpike(DecoratorFeatureGenerator gen, double x, double y, double z, Vec3 dirVec) {
        boolean placedSomething = false;
        x -= dirVec.field_72450_a * 16.0;
        y -= dirVec.field_72448_b * 16.0;
        z -= dirVec.field_72449_c * 16.0;
        for (int unit = 0; unit < 32; ++unit) {
            int iz;
            int iy;
            int ix = MathUtil.floor(x);
            if (gen.getBlock(ix, iy = MathUtil.floor(y), iz = MathUtil.floor(z)) == Blocks.field_150377_bs) {
                gen.setBlock(ix, iy, iz, this.block);
                placedSomething = true;
            }
            x += dirVec.field_72450_a;
            y += dirVec.field_72448_b;
            z += dirVec.field_72449_c;
        }
        return placedSomething;
    }
}

