/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.mountains;

import chylex.hee.init.BlockList;
import chylex.hee.world.structure.island.biome.IslandBiomeBurningMountains;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class StructureResourcePit
extends AbstractIslandStructure {
    @Override
    protected boolean generate(Random rand) {
        double rad = rand.nextDouble() * 2.5 + 3.5;
        byte height = (byte)(rand.nextInt(10) + 12 + (this.biomeData.hasDeviation(IslandBiomeBurningMountains.DEEP_RESOURCE_PITS) ? 6 + rand.nextInt(10) : 0));
        byte by = (int)Math.ceil(rad);
        byte[] xOff = new byte[]{-by, by, 0, 0};
        byte[] zOff = new byte[]{0, 0, by, -by};
        boolean[][] holes = new boolean[by * 2 + 1][by * 2 + 1];
        for (int x = -by; x <= by; ++x) {
            for (byte z = -by; z <= by; ++z) {
                holes[x + by][z + by] = (double)(x * x + z * z) <= rad * rad;
            }
        }
        for (int attempt = 0; attempt < 60; ++attempt) {
            int x = this.getRandomXZ(rand, 8);
            int z = this.getRandomXZ(rand, 8);
            boolean canGenerate = true;
            int maxy = 0;
            int btmh = 0;
            for (int a = 0; a < 4; ++a) {
                int toph = this.world.getHighestY(x + xOff[a], z + zOff[a]);
                if (toph == 0) {
                    canGenerate = false;
                    break;
                }
                for (int y = 0; y < toph; ++y) {
                    if (this.world.isAir(x, y, z)) continue;
                    btmh = y;
                    break;
                }
                if (btmh == 0 || toph - btmh < height + 7 || maxy != 0 && Math.abs(toph - maxy) > 8) {
                    canGenerate = false;
                    break;
                }
                if (toph <= maxy) continue;
                maxy = toph;
            }
            if (!canGenerate) continue;
            for (int py = maxy; py > maxy - height - rand.nextInt(4); --py) {
                for (byte px = -by; px <= by; ++px) {
                    for (byte pz = -by; pz <= by; ++pz) {
                        if (!holes[px + by][pz + by]) continue;
                        this.world.setBlock(x + px, py, z + pz, (Block)(py < maxy - height + 3 ? Blocks.field_150356_k : Blocks.field_150350_a), 0, py < maxy - height + 3);
                    }
                }
            }
            int placed = 0;
            int max = 25 + rand.nextInt(18);
            for (int featureAttempt = 0; featureAttempt < 580 + height * 5 + by * by * 4 && placed < max + rand.nextInt(8); ++featureAttempt) {
                int pz;
                int py;
                int px = x + rand.nextInt(by + 1) - rand.nextInt(by + 1);
                if (this.world.getBlock(px, py = Math.min(maxy - 1, (int)((double)(maxy - height) + Math.abs(rand.nextGaussian() * (double)height * 0.65))), pz = z + rand.nextInt(by + 1) - rand.nextInt(by + 1)) != Blocks.field_150377_bs || !this.world.isAir(px - 1, py, pz) && !this.world.isAir(px + 1, py, pz) && !this.world.isAir(px, py, pz - 1) && !this.world.isAir(px, py, pz + 1)) continue;
                if (rand.nextInt(9) <= 7) {
                    this.world.setBlock(px, py, pz, StructureResourcePit.getOre(rand));
                } else {
                    this.world.setBlock(px, py, pz, (Block)Blocks.field_150356_k, 0, true);
                }
                ++placed;
            }
            return true;
        }
        return false;
    }

    private static Block getOre(Random rand) {
        int i = rand.nextInt(19);
        if (i < 5) {
            return BlockList.igneous_rock_ore;
        }
        if (i < 11) {
            return BlockList.end_powder_ore;
        }
        if (i < 15) {
            return BlockList.instability_orb_ore;
        }
        return BlockList.stardust_ore;
    }
}

