/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.brewing;

import chylex.hee.mechanics.brewing.AbstractPotionData;
import chylex.hee.mechanics.brewing.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class TimedPotion
extends AbstractPotionData {
    protected int startDuration;
    protected int maxDuration;
    protected int durationStep;

    public TimedPotion(Potion potion, int requiredDamageValue, int damageValue, int maxLevel, int maxLevelEnhanced, int startDuration, int maxDuration) {
        this(potion, requiredDamageValue, damageValue, maxLevel, maxLevelEnhanced, startDuration, maxDuration, 75);
    }

    public TimedPotion(Potion potion, int requiredDamageValue, int damageValue, int maxLevel, int maxLevelEnhanced, int startDuration, int maxDuration, int durationStep) {
        super(potion, requiredDamageValue, damageValue, maxLevel, maxLevelEnhanced);
        this.startDuration = startDuration * 20;
        this.maxDuration = maxDuration * 20;
        this.durationStep = durationStep * 20;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public int getDurationStep() {
        return this.durationStep;
    }

    public int getDurationLevel(int duration) {
        return (duration - this.startDuration) / this.durationStep;
    }

    @Override
    public void onFirstBrewingFinished(ItemStack is) {
        super.onFirstBrewingFinished(is);
        PotionEffect eff = PotionTypes.getEffectIfValid(is);
        if (eff != null) {
            PotionTypes.setCustomPotionEffect(is, new PotionEffect(eff.func_76456_a(), this.startDuration, eff.func_76458_c(), eff.func_82720_e()));
        }
    }

    public boolean canIncreaseDuration(ItemStack is) {
        PotionEffect effect = PotionTypes.getEffectIfValid(is);
        return effect != null && effect.func_76456_a() == this.potion.field_76415_H && effect.func_76459_b() < this.maxDuration;
    }
}

