/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.feature.blobs.populators;

import chylex.hee.system.util.BlockPosM;
import chylex.hee.world.feature.blobs.BlobPopulator;
import chylex.hee.world.feature.util.DecoratorFeatureGenerator;
import chylex.hee.world.util.IRandomAmount;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class BlobPopulatorOreScattered
extends BlobPopulator {
    private Block ore;
    private IRandomAmount blockAmountGen = IRandomAmount.exact;
    private byte minAttempts;
    private byte maxAttempts;
    private byte minBlockAmount;
    private byte maxBlockAmount;
    private byte visiblePlacementAttempts;
    private boolean knownBlockLocations;

    public BlobPopulatorOreScattered(int weight) {
        super(weight);
    }

    public BlobPopulatorOreScattered block(Block ore) {
        this.ore = ore;
        return this;
    }

    public BlobPopulatorOreScattered attempts(int minAttempts, int maxAttempts) {
        this.minAttempts = (byte)minAttempts;
        this.maxAttempts = (byte)maxAttempts;
        return this;
    }

    public BlobPopulatorOreScattered blockAmount(IRandomAmount blockAmountGen, int minBlockAmount, int maxBlockAmount) {
        this.blockAmountGen = blockAmountGen;
        this.minBlockAmount = (byte)minBlockAmount;
        this.maxBlockAmount = (byte)maxBlockAmount;
        return this;
    }

    public BlobPopulatorOreScattered visiblePlacementAttempts(int visiblePlacementAttempts) {
        this.visiblePlacementAttempts = (byte)visiblePlacementAttempts;
        return this;
    }

    public BlobPopulatorOreScattered knownBlockLocations() {
        this.knownBlockLocations = true;
        return this;
    }

    @Override
    public void generate(DecoratorFeatureGenerator gen, Random rand) {
        int blocks = this.blockAmountGen.generate(rand, this.minBlockAmount, this.maxBlockAmount);
        List<BlockPosM> locs = this.knownBlockLocations ? gen.getUsedLocations() : null;
        int attempts = this.minAttempts + rand.nextInt(this.maxAttempts - this.minAttempts + 1);
        for (int attempt = 0; attempt < attempts && blocks > 0; ++attempt) {
            int z;
            int y;
            int x;
            if (this.knownBlockLocations) {
                if (locs.isEmpty()) {
                    return;
                }
                BlockPosM loc = locs.get(rand.nextInt(locs.size()));
                x = loc.x;
                y = loc.y;
                z = loc.z;
            } else {
                x = rand.nextInt(32) - 16;
                y = rand.nextInt(32) - 16;
                z = rand.nextInt(32) - 16;
            }
            if (gen.getBlock(x, y, z) != Blocks.field_150377_bs) continue;
            if (this.visiblePlacementAttempts > 0) {
                int origX = x;
                int origY = y;
                int origZ = z;
                for (int airAttempt = 0; !(airAttempt > this.visiblePlacementAttempts || gen.getBlock(x, y, z) == Blocks.field_150377_bs && this.isAirAdjacent(gen, x, y, z)); ++airAttempt) {
                    if (airAttempt == this.visiblePlacementAttempts) {
                        x = origX;
                        y = origY;
                        z = origZ;
                        break;
                    }
                    x += rand.nextInt(6) - 3;
                    y += rand.nextInt(6) - 3;
                    z += rand.nextInt(6) - 3;
                }
            }
            gen.setBlock(x, y, z, this.ore);
            --blocks;
        }
    }

    private boolean isAirAdjacent(DecoratorFeatureGenerator gen, int x, int y, int z) {
        return gen.getBlock(x - 1, y, z) == Blocks.field_150350_a || gen.getBlock(x + 1, y, z) == Blocks.field_150350_a || gen.getBlock(x, y - 1, z) == Blocks.field_150350_a || gen.getBlock(x, y + 1, z) == Blocks.field_150350_a || gen.getBlock(x, y, z - 1) == Blocks.field_150350_a || gen.getBlock(x, y, z + 1) == Blocks.field_150350_a;
    }
}

