/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.entity.mob.teleport;

import chylex.hee.system.abstractions.Pos;
import chylex.hee.system.abstractions.Vec;
import chylex.hee.system.util.MathUtil;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.world.IBlockAccess;

public interface ITeleportPredicate<T extends Entity> {
    public static final ITeleportPredicate noCollision = (entity, startPos, rand) -> entity.field_70170_p.func_72945_a(entity, entity.field_70121_D).isEmpty();
    public static final ITeleportPredicate noLiquid = (entity, startPos, rand) -> !entity.field_70170_p.func_72953_d(entity.field_70121_D);

    public boolean isValid(T var1, Vec var2, Random var3);

    public static <T extends Entity> ITeleportPredicate<T> airAboveSolid(int airBlocks) {
        return (entity, startPos, rand) -> {
            Pos entityPos = Pos.at((Entity)entity);
            if (!entityPos.getDown().getMaterial((IBlockAccess)entity.field_70170_p).func_76230_c()) {
                return false;
            }
            for (int y = 0; y < airBlocks; ++y) {
                if (entityPos.offset(0, y, 0).isAir((IBlockAccess)entity.field_70170_p)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T extends Entity> ITeleportPredicate<T> minDistance(double minDist) {
        double minDistSq = MathUtil.square(minDist);
        return (entity, startPos, rand) -> MathUtil.distanceSquared(entity.field_70165_t - startPos.x, entity.field_70163_u - startPos.y, entity.field_70161_v - startPos.z) >= minDistSq;
    }
}

