/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.game.commands;

import chylex.hee.HardcoreEnderExpansion;
import chylex.hee.entity.block.EntityBlockEnderCrystal;
import chylex.hee.entity.block.EntityBlockTokenHolder;
import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.entity.boss.dragon.attacks.special.DragonSpecialAttackBase;
import chylex.hee.game.commands.BaseCommand;
import chylex.hee.game.commands.HeeDebugCommand;
import chylex.hee.game.commands.SubCommand;
import chylex.hee.game.save.SaveData;
import chylex.hee.game.save.types.player.CausatumFile;
import chylex.hee.game.save.types.player.CompendiumFile;
import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.curse.ICurseCaller;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C19CompendiumData;
import chylex.hee.system.abstractions.entity.EntitySelector;
import chylex.hee.system.logging.Log;
import chylex.hee.system.update.UpdateNotificationManager;
import chylex.hee.system.util.DragonUtil;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.TeleportHandler;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.boss.IBossDisplayData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.stats.Achievement;
import net.minecraft.stats.AchievementList;
import net.minecraft.stats.StatBase;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class HeeAdminCommand
extends BaseCommand {
    private static final String pre = EnumChatFormatting.DARK_PURPLE + "[HEE] " + EnumChatFormatting.RESET;
    private List<SubCommand> sub = new ArrayList<SubCommand>();

    public HeeAdminCommand() {
        super("heeadmin");
        this.sub.add(new SubCommand("help", "<page>", 0, false){

            @Override
            void run(ICommandSender sender, String[] args) {
            }
        });
        this.sub.add(new SubCommand("version", 0, false){

            @Override
            void run(ICommandSender sender, String[] args) {
                HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.DARK_PURPLE + "Hardcore Ender Expansion");
                HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.LIGHT_PURPLE + "Version: " + EnumChatFormatting.RESET + HardcoreEnderExpansion.modVersion + "/" + 2696150);
                HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.LIGHT_PURPLE + "Mod file: " + EnumChatFormatting.RESET + (Log.isDeobfEnvironment ? "<deobf>" : HardcoreEnderExpansion.sourceFile.getName()));
                if (UpdateNotificationManager.enableNotifications || UpdateNotificationManager.enableBuildCheck) {
                    HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.LIGHT_PURPLE + "Available for: " + EnumChatFormatting.RESET + UpdateNotificationManager.mcVersions);
                    HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.LIGHT_PURPLE + "Release date: " + EnumChatFormatting.RESET + UpdateNotificationManager.releaseDate);
                } else {
                    HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.GRAY + "Update information unavailable, notifications are disabled.");
                }
            }
        });
        this.sub.add(new SubCommand("kill-bosses", 0, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                int counter = 0;
                for (Entity e : EntitySelector.any((World)sender.func_130014_f_())) {
                    if (!(e instanceof IBossDisplayData) || !(e instanceof EntityLiving)) continue;
                    ((EntityLiving)e).func_70606_j(0.0f);
                    ++counter;
                }
                HeeAdminCommand.this.sendMessage(sender, pre + "Killed " + counter + " entit" + (counter == 1 ? "y" : "ies") + ".");
            }
        });
        this.sub.add(new SubCommand("compendium-set-points", "<pts>", 1, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                EntityPlayer player = (EntityPlayer)sender;
                int amount = DragonUtil.tryParse(args[0], -1);
                if (amount == -1) {
                    HeeAdminCommand.this.sendMessage(sender, "Invalid number.");
                    return;
                }
                CompendiumFile file = CompendiumEvents.getPlayerData((EntityPlayer)player);
                file.offsetPoints(-file.getPoints() + amount);
                PacketPipeline.sendToPlayer(player, new C19CompendiumData(player));
                HeeAdminCommand.this.sendMessage(sender, "Compendium points updated.");
            }
        });
        this.sub.add(new SubCommand("compendium-unlock-all", 0, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                EntityPlayer player = (EntityPlayer)sender;
                CompendiumFile file = CompendiumEvents.getPlayerData((EntityPlayer)player);
                for (KnowledgeObject object : KnowledgeObject.getAllObjects()) {
                    file.tryDiscoverObject(player, object, true);
                }
                for (KnowledgeFragment fragment : KnowledgeFragment.getUnlockableFragments()) {
                    file.unlockFragment(fragment);
                }
                PacketPipeline.sendToPlayer(player, new C19CompendiumData(player));
                HeeAdminCommand.this.sendMessage(sender, pre + "Compendium data unlocked.");
            }
        });
        this.sub.add(new SubCommand("compendium-reset", 0, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                EntityPlayer player = (EntityPlayer)sender;
                CompendiumEvents.getPlayerData((EntityPlayer)player).reset();
                PacketPipeline.sendToPlayer(player, new C19CompendiumData(player));
                HeeAdminCommand.this.sendMessage(sender, pre + "Compendium data reset.");
            }
        });
        this.sub.add(new SubCommand("spawn-entity", "<endercrystal|tokenholder>", 1, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                EntityPlayer player = (EntityPlayer)sender;
                Object e = null;
                switch (args[0]) {
                    case "endercrystal": {
                        e = new EntityBlockEnderCrystal(player.field_70170_p);
                        break;
                    }
                    case "tokenholder": {
                        e = new EntityBlockTokenHolder(player.field_70170_p);
                    }
                }
                if (e == null) {
                    HeeAdminCommand.this.sendMessage(sender, pre + "Unknown entity.");
                } else {
                    e.func_70107_b(player.field_70165_t, player.field_70163_u, player.field_70161_v);
                    player.field_70170_p.func_72838_d((Entity)e);
                    HeeAdminCommand.this.sendMessage(sender, pre + "Entity spawned.");
                }
            }
        });
        this.sub.add(new SubCommand("causatum-check", 0, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                CausatumFile file = SaveData.player((EntityPlayer)sender, CausatumFile.class);
                HeeAdminCommand.this.sendMessage(sender, EnumChatFormatting.DARK_PURPLE + "Ender Causatum");
            }
        });
        this.sub.add(new SubCommand("dragon-set-angry", 0, false){

            @Override
            void run(ICommandSender sender, String[] args) {
                EntityBossDragon dragon = HeeDebugCommand.getDragon();
                if (dragon == null) {
                    HeeAdminCommand.this.sendMessage(sender, pre + "Dragon is not loaded.");
                } else {
                    dragon.setAngry(true);
                    HeeAdminCommand.this.sendMessage(sender, pre + "Dragon state updated.");
                }
            }
        });
        this.sub.add(new SubCommand("dragon-set-attack", "<none|divebomb|fireburst|punch|summoning|bloodlust>", 1, false){

            @Override
            void run(ICommandSender sender, String[] args) {
                EntityBossDragon dragon = HeeDebugCommand.getDragon();
                if (dragon == null) {
                    HeeAdminCommand.this.sendMessage(sender, "Dragon not loaded.");
                    return;
                }
                Object[] ids = new String[]{"none", "divebomb", "fireburst", "punch", "summoning", "bloodlust"};
                DragonSpecialAttackBase att = dragon.attacks.getSpecialAttackById(ArrayUtils.indexOf((Object[])ids, (Object)args[0]));
                if (att != null) {
                    dragon.forceSpecialAttack(att);
                    HeeAdminCommand.this.sendMessage(sender, pre + "Dragon attack set.");
                } else {
                    HeeAdminCommand.this.sendMessage(sender, pre + "Attack not found.");
                }
            }
        });
        this.sub.add(new SubCommand("purify-loaded-curses", 0, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                int counter = 0;
                for (Entity entity : EntitySelector.any((World)sender.func_130014_f_())) {
                    if (!(entity instanceof ICurseCaller)) continue;
                    entity.func_70106_y();
                    ((ICurseCaller)entity).onPurify();
                    ++counter;
                }
                HeeAdminCommand.this.sendMessage(sender, pre + "Purified " + counter + " curse" + (counter == 1 ? "." : "es."));
            }
        });
        this.sub.add(new SubCommand("tp-overworld", 0, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                ((EntityPlayerMP)sender).field_71088_bW = 10;
                TeleportHandler.toOverworld((EntityPlayerMP)((EntityPlayerMP)sender));
            }
        });
        this.sub.add(new SubCommand("achievement-unlock", "<id>", 1, true){

            @Override
            void run(ICommandSender sender, String[] args) {
                for (Achievement achievement : AchievementList.field_76007_e) {
                    if (!achievement.field_75975_e.equals(args[0])) continue;
                    ((EntityPlayer)sender).func_71064_a((StatBase)achievement, 1);
                    HeeAdminCommand.this.sendMessage(sender, pre + "Attempted to unlock.");
                    return;
                }
                HeeAdminCommand.this.sendMessage(sender, pre + "Achievement not found.");
            }
        });
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        int helpPage;
        int n = args.length == 0 ? 0 : (args[0].equalsIgnoreCase("help") ? DragonUtil.tryParse(args.length == 2 ? args[1] : "1", 1) - 1 : (helpPage = -1));
        if (helpPage >= 0) {
            int cmdsPerPage = 7;
            int pages = MathUtil.ceil((float)this.sub.size() / 7.0f);
            if (helpPage >= pages - 1) {
                helpPage = pages - 1;
            }
            this.sendMessage(sender, EnumChatFormatting.GREEN + "[Hardcore Ender Expansion] page " + (helpPage + 1) + "/" + pages);
            for (int a = helpPage * 7; a < Math.min((helpPage + 1) * 7, this.sub.size()); ++a) {
                SubCommand cmd = this.sub.get(a);
                this.sendMessage(sender, "/heeadmin " + cmd.name + (cmd.arguments == null ? "" : " " + cmd.arguments));
            }
        } else {
            for (SubCommand cmd : this.sub) {
                if (!cmd.name.equalsIgnoreCase(args[0])) continue;
                if (args.length <= cmd.argCount) {
                    this.sendMessage(sender, pre + "Invalid amount of parameters.");
                } else if (cmd.requiresPlayer && !(sender instanceof EntityPlayer)) {
                    this.sendMessage(sender, pre + "You need to be in-game to invoke this command.");
                } else {
                    cmd.run(sender, (String[])ArrayUtils.remove((Object[])args, (int)0));
                }
                return;
            }
            this.sendMessage(sender, pre + "Unknown command.");
        }
    }
}

