/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.mechanics.enhancements;

import chylex.hee.init.BlockList;
import chylex.hee.init.ItemList;
import chylex.hee.mechanics.enhancements.EnhancementData;
import chylex.hee.mechanics.enhancements.IEnhancementEnum;
import chylex.hee.mechanics.enhancements.SlotList;
import chylex.hee.mechanics.enhancements.types.EnderPearlEnhancements;
import chylex.hee.mechanics.enhancements.types.EnhancedBrewingStandEnhancements;
import chylex.hee.mechanics.enhancements.types.EssenceAltarEnhancements;
import chylex.hee.mechanics.enhancements.types.SpatialDashGemEnhancements;
import chylex.hee.mechanics.enhancements.types.TNTEnhancements;
import chylex.hee.mechanics.enhancements.types.TransferenceGemEnhancements;
import chylex.hee.system.util.CollectionUtil;
import chylex.hee.system.util.ItemUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;

public final class EnhancementHandler {
    private static final IdentityHashMap<Item, EnhancementData> itemMap = new IdentityHashMap(8);

    private static void register(Item[] items, EnhancementData data) {
        for (Item item : items) {
            itemMap.put(item, data);
        }
    }

    public static boolean canEnhanceItem(Item item) {
        return itemMap.containsKey(item);
    }

    public static boolean canEnhanceBlock(Block block) {
        return itemMap.containsKey(Item.func_150898_a((Block)block));
    }

    public static List<IEnhancementEnum> getAllEnhancements() {
        ArrayList<IEnhancementEnum> list = new ArrayList<IEnhancementEnum>();
        for (EnhancementData data : itemMap.values()) {
            for (IEnhancementEnum enhancement : data.valuesInterface) {
                list.add(enhancement);
            }
        }
        return list;
    }

    public static List<IEnhancementEnum> getEnhancementsForItem(Item item) {
        return EnhancementHandler.canEnhanceItem(item) ? CollectionUtil.newList(EnhancementHandler.itemMap.get((Object)item).valuesInterface) : new ArrayList<IEnhancementEnum>();
    }

    public static SlotList getEnhancementSlotsForItem(Item item) {
        return EnhancementHandler.canEnhanceItem(item) ? EnhancementHandler.itemMap.get((Object)item).slots : new SlotList(new SlotList.SlotType[0]);
    }

    public static List<Enum> getEnhancements(ItemStack is) {
        ArrayList<Enum> enhancements = new ArrayList<Enum>();
        if (!is.func_77942_o() || !EnhancementHandler.canEnhanceItem(is.func_77973_b())) {
            return enhancements;
        }
        NBTTagList list = is.func_77978_p().func_150295_c("HEE_enhancements", 8);
        EnhancementData enhancementData = itemMap.get(is.func_77973_b());
        block0: for (int a = 0; a < list.func_74745_c(); ++a) {
            String name = list.func_150307_f(a);
            for (Enum e : enhancementData.valuesEnum) {
                if (!e.name().equals(name)) continue;
                enhancements.add(e);
                continue block0;
            }
        }
        return enhancements;
    }

    public static Item getEnhancementTransformation(ItemStack is) {
        return EnhancementHandler.canEnhanceItem(is.func_77973_b()) ? EnhancementHandler.itemMap.get((Object)is.func_77973_b()).newItem : is.func_77973_b();
    }

    public static boolean hasEnhancement(ItemStack is, Enum enhancement) {
        return EnhancementHandler.getEnhancements(is).contains(enhancement);
    }

    public static ItemStack addEnhancement(ItemStack is, Object enhancement) {
        if (!(enhancement instanceof IEnhancementEnum)) {
            throw new IllegalArgumentException("Tried adding foreign object " + enhancement + " as an enhancement!");
        }
        return EnhancementHandler.addEnhancement(is, (Enum)enhancement);
    }

    public static ItemStack addEnhancement(ItemStack is, Enum enhancement) {
        if (EnhancementHandler.getEnhancements(is).contains(enhancement) || !EnhancementHandler.canEnhanceItem(is.func_77973_b())) {
            return is;
        }
        is = is.func_77946_l();
        is.func_150996_a(EnhancementHandler.itemMap.get((Object)is.func_77973_b()).newItem);
        EnhancementHandler.addEnhancementToItemStack(is, enhancement);
        return is;
    }

    public static ItemStack addEnhancements(ItemStack is, Collection<Enum> enhancements) {
        if (!EnhancementHandler.canEnhanceItem(is.func_77973_b()) || enhancements.isEmpty()) {
            return is;
        }
        is = is.func_77946_l();
        is.func_150996_a(EnhancementHandler.itemMap.get((Object)is.func_77973_b()).newItem);
        List<Enum> current = EnhancementHandler.getEnhancements(is);
        for (Enum enhancement : enhancements) {
            if (current.contains(enhancement)) continue;
            EnhancementHandler.addEnhancementToItemStack(is, enhancement);
        }
        return is;
    }

    public static void addEnhancementToItemStack(ItemStack is, Enum enhancement) {
        NBTTagCompound nbt = ItemUtil.getTagRoot(is, true);
        NBTTagList list = nbt.func_150295_c("HEE_enhancements", 8);
        list.func_74742_a((NBTBase)new NBTTagString(enhancement.name()));
        nbt.func_74782_a("HEE_enhancements", (NBTBase)list);
    }

    public static void appendEnhancementNames(ItemStack is, List list) {
        for (Enum e : EnhancementHandler.getEnhancements(is)) {
            list.add(((IEnhancementEnum)((Object)e)).getName());
        }
    }

    private EnhancementHandler() {
    }

    static {
        SlotList.SlotType p = SlotList.SlotType.POWDER;
        SlotList.SlotType i = SlotList.SlotType.INGREDIENT;
        EnhancementHandler.register(new Item[]{Items.field_151079_bi, ItemList.enhanced_ender_pearl}, new EnhancementData(EnderPearlEnhancements.class, ItemList.enhanced_ender_pearl, p, i, p));
        EnhancementHandler.register(new Item[]{ItemList.spatial_dash_gem}, new EnhancementData(SpatialDashGemEnhancements.class, ItemList.spatial_dash_gem, p, p, i, i, i, i, p, p));
        EnhancementHandler.register(new Item[]{ItemList.transference_gem}, new EnhancementData(TransferenceGemEnhancements.class, ItemList.transference_gem, p, p, i, i, i, i, p, p));
        EnhancementHandler.register(new Item[]{Item.func_150898_a((Block)Blocks.field_150335_W), Item.func_150898_a((Block)BlockList.enhanced_tnt)}, new EnhancementData(TNTEnhancements.class, Item.func_150898_a((Block)BlockList.enhanced_tnt), p, p, i, i, p, p));
        EnhancementHandler.register(new Item[]{Item.func_150898_a((Block)BlockList.essence_altar)}, new EnhancementData(EssenceAltarEnhancements.class, Item.func_150898_a((Block)BlockList.essence_altar), p, p, i, i, i, p, p));
        EnhancementHandler.register(new Item[]{Item.func_150898_a((Block)BlockList.enhanced_brewing_stand), ItemList.enhanced_brewing_stand}, new EnhancementData(EnhancedBrewingStandEnhancements.class, ItemList.enhanced_brewing_stand, p, i, i, i, i, i, p));
    }
}

