/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.system.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public final class CollectionUtil {
    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> sortMapByValueAsc(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sorted = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int r = ((Comparable)e1.getValue()).compareTo(e2.getValue());
                return r == 0 ? 1 : r;
            }
        });
        for (Map.Entry<K, V> entry : map.entrySet()) {
            sorted.add(new AbstractMap.SimpleEntry<K, V>(entry));
        }
        return sorted;
    }

    public static <K, V extends Comparable<? super V>> SortedSet<Map.Entry<K, V>> sortMapByValueDesc(Map<K, V> map) {
        TreeSet<Map.Entry<K, V>> sorted = new TreeSet<Map.Entry<K, V>>(new Comparator<Map.Entry<K, V>>(){

            @Override
            public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                int r = ((Comparable)e2.getValue()).compareTo(e1.getValue());
                return r == 0 ? 1 : r;
            }
        });
        for (Map.Entry<K, V> entry : map.entrySet()) {
            sorted.add(new AbstractMap.SimpleEntry<K, V>(entry));
        }
        return sorted;
    }

    public static <T> ArrayList<T> newList(T ... elements) {
        ArrayList list = new ArrayList(elements.length);
        Collections.addAll(list, elements);
        return list;
    }

    public static <T> ArrayList<T> newList(int capacity, T ... elements) {
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, elements);
        return list;
    }

    private CollectionUtil() {
    }
}

