/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.InfernalMobsCore;
import atomicstryker.infernalmobs.common.MobModifier;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.DamageSource;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.ChunkEvent;

public class EntityEventHandler {
    private final boolean antiMobFarm;
    private final long mobFarmCheckIntervals;
    private final float mobFarmDamageTrigger;
    private final HashMap<ChunkCoordIntPair, Float> damageMap;
    private long nextMapEvaluation;

    public EntityEventHandler() {
        Configuration config = InfernalMobsCore.instance().config;
        config.load();
        this.antiMobFarm = config.get("general", "AntiMobfarmingEnabled", true, "Anti Mob farming mechanic. Might cause overhead if enabled.").getBoolean(true);
        this.mobFarmCheckIntervals = (long)config.get("general", "AntiMobFarmCheckInterval", 30, "time in seconds between mob check intervals. Higher values cost more performance, but might be more accurate.").getInt() * 1000L;
        this.mobFarmDamageTrigger = (float)config.get("general", "mobFarmDamageThreshold", 150.0, "Damage in chunk per interval that triggers anti farm effects").getDouble(150.0);
        config.save();
        this.damageMap = new HashMap();
        this.nextMapEvaluation = System.currentTimeMillis();
    }

    @SubscribeEvent
    public void onEntityJoinedWorld(EntityJoinWorldEvent event) {
        if (event.entity instanceof EntityLivingBase) {
            String savedMods = event.entity.getEntityData().func_74779_i(InfernalMobsCore.instance().getNBTTag());
            if (!savedMods.equals("")) {
                InfernalMobsCore.instance().addEntityModifiersByString((EntityLivingBase)event.entity, savedMods);
            } else {
                InfernalMobsCore.instance().processEntitySpawn((EntityLivingBase)event.entity);
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDeath(LivingDeathEvent event) {
        MobModifier mod;
        if (!event.entity.field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.entityLiving)) != null && mod.onDeath()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onEntityLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        MobModifier mod;
        if (!event.entity.field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.entityLiving)) != null) {
            mod.onSetAttackTarget(event.target);
        }
    }

    @SubscribeEvent
    public void onEntityLivingAttacked(LivingAttackEvent event) {
    }

    @SubscribeEvent
    public void onEntityLivingHurt(LivingHurtEvent event) {
        if (event.source.func_76346_g() != event.entityLiving) {
            Entity attacker;
            MobModifier mod = InfernalMobsCore.getMobModifiers(event.entityLiving);
            if (mod != null) {
                event.ammount = mod.onHurt(event.entityLiving, event.source, event.ammount);
            }
            if ((attacker = event.source.func_76346_g()) instanceof EntityLivingBase && !event.source.field_76373_n.equals("thorns") && (mod = InfernalMobsCore.getMobModifiers((EntityLivingBase)attacker)) != null) {
                event.ammount = mod.onAttack(event.entityLiving, event.source, event.ammount);
            }
            if (this.antiMobFarm && (event.source == DamageSource.field_76367_g || event.source == DamageSource.field_76369_e || event.source == DamageSource.field_76379_h || event.source == DamageSource.field_76368_d || event.source == DamageSource.field_76371_c || event.source.func_76346_g() instanceof FakePlayer)) {
                ChunkCoordIntPair cpair = new ChunkCoordIntPair((int)event.entityLiving.field_70165_t, (int)event.entityLiving.field_70161_v);
                Float value = this.damageMap.get(cpair);
                if (value == null) {
                    for (Map.Entry<ChunkCoordIntPair, Float> e : this.damageMap.entrySet()) {
                        if (Math.abs(e.getKey().field_77276_a - cpair.field_77276_a) >= 3 || Math.abs(e.getKey().field_77275_b - cpair.field_77275_b) >= 3) continue;
                        e.setValue(Float.valueOf(e.getValue().floatValue() + event.ammount));
                        break;
                    }
                } else {
                    this.damageMap.put(cpair, Float.valueOf(value.floatValue() + event.ammount));
                }
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingFall(LivingFallEvent event) {
        MobModifier mod;
        if (!event.entity.field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.entityLiving)) != null) {
            event.setCanceled(mod.onFall(event.distance));
        }
    }

    @SubscribeEvent
    public void onEntityLivingJump(LivingEvent.LivingJumpEvent event) {
        MobModifier mod;
        if (!event.entity.field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.entityLiving)) != null) {
            mod.onJump(event.entityLiving);
        }
    }

    @SubscribeEvent
    public void onEntityLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        if (!event.entityLiving.field_70170_p.field_72995_K) {
            MobModifier mod = InfernalMobsCore.getMobModifiers(event.entityLiving);
            if (mod != null) {
                mod.onUpdate(event.entityLiving);
            }
            if (this.antiMobFarm && System.currentTimeMillis() > this.nextMapEvaluation) {
                if (!this.damageMap.isEmpty()) {
                    float maxDamage = 0.0f;
                    ChunkCoordIntPair maxC = null;
                    for (Map.Entry<ChunkCoordIntPair, Float> e : this.damageMap.entrySet()) {
                        float val = e.getValue().floatValue();
                        if (!(val > maxDamage)) continue;
                        maxC = e.getKey();
                        maxDamage = val;
                    }
                    if (maxDamage > this.mobFarmDamageTrigger) {
                        MinecraftForge.EVENT_BUS.post((Event)new MobFarmDetectedEvent(event.entityLiving.field_70170_p.func_72964_e(maxC.field_77276_a, maxC.field_77275_b), this.mobFarmCheckIntervals, maxDamage));
                    }
                    this.damageMap.clear();
                }
                this.nextMapEvaluation = System.currentTimeMillis() + this.mobFarmCheckIntervals;
            }
        }
    }

    @SubscribeEvent
    public void onEntityLivingDrops(LivingDropsEvent event) {
        MobModifier mod;
        if (!event.entity.field_70170_p.field_72995_K && (mod = InfernalMobsCore.getMobModifiers(event.entityLiving)) != null) {
            mod.onDropItems(event.entityLiving, event.source, event.drops, event.lootingLevel, event.recentlyHit, event.specialDropValue);
            InfernalMobsCore.removeEntFromElites(event.entityLiving);
        }
    }

    public static class MobFarmDetectedEvent
    extends ChunkEvent {
        public final long triggeringInterval;
        public final float triggeringDamage;

        public MobFarmDetectedEvent(Chunk chunk, long ti, float td) {
            super(chunk);
            this.triggeringInterval = ti;
            this.triggeringDamage = td;
        }
    }
}

