/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common.network;

import cpw.mods.fml.common.network.FMLEmbeddedChannel;
import cpw.mods.fml.common.network.FMLIndexedMessageToMessageCodec;
import cpw.mods.fml.common.network.FMLOutboundHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayerMP;

public class NetworkHelper {
    private final FMLEmbeddedChannel clientOutboundChannel;
    private final FMLEmbeddedChannel serverOutboundChannel;
    private final HashSet<Class<? extends IPacket>> registeredClasses;
    private boolean isCurrentlySendingSemaphor;

    @SafeVarargs
    public NetworkHelper(String channelName, Class<? extends IPacket> ... handledPacketClasses) {
        EnumMap channelPair = NetworkRegistry.INSTANCE.newChannel(channelName, new io.netty.channel.ChannelHandler[]{new ChannelCodec(handledPacketClasses), new ChannelHandler()});
        this.clientOutboundChannel = (FMLEmbeddedChannel)channelPair.get(Side.CLIENT);
        this.serverOutboundChannel = (FMLEmbeddedChannel)channelPair.get(Side.SERVER);
        this.registeredClasses = new HashSet(handledPacketClasses.length);
        this.registeredClasses.addAll(Arrays.asList(handledPacketClasses));
    }

    public void sendPacketToServer(IPacket packet) {
        this.checkClassAndSync(packet.getClass());
        this.clientOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.TOSERVER);
        this.clientOutboundChannel.writeOutbound(new Object[]{packet});
        this.isCurrentlySendingSemaphor = false;
    }

    public void sendPacketToPlayer(IPacket packet, EntityPlayerMP player) {
        this.checkClassAndSync(packet.getClass());
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.PLAYER);
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)player);
        this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        this.isCurrentlySendingSemaphor = false;
    }

    public void sendPacketToAllPlayers(IPacket packet) {
        this.checkClassAndSync(packet.getClass());
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALL);
        this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        this.isCurrentlySendingSemaphor = false;
    }

    public void sendPacketToAllAroundPoint(IPacket packet, NetworkRegistry.TargetPoint tp) {
        this.checkClassAndSync(packet.getClass());
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT);
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)tp);
        this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        this.isCurrentlySendingSemaphor = false;
    }

    public void sendPacketToAllInDimension(IPacket packet, int dimension) {
        this.checkClassAndSync(packet.getClass());
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)FMLOutboundHandler.OutboundTarget.DIMENSION);
        this.serverOutboundChannel.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set((Object)dimension);
        this.serverOutboundChannel.writeOutbound(new Object[]{packet});
        this.isCurrentlySendingSemaphor = false;
    }

    private void checkClassAndSync(Class<? extends IPacket> clazz) {
        if (!this.registeredClasses.contains(clazz)) {
            throw new RuntimeException("NetworkHelper got unknown Packet type " + clazz + " to send, critical error");
        }
        while (this.isCurrentlySendingSemaphor) {
            Thread.yield();
        }
        this.isCurrentlySendingSemaphor = true;
    }

    private static class ChannelCodec
    extends FMLIndexedMessageToMessageCodec<IPacket> {
        @SafeVarargs
        public ChannelCodec(Class<? extends IPacket> ... handledPacketClasses) {
            for (int i = 0; i < handledPacketClasses.length; ++i) {
                this.addDiscriminator(i, handledPacketClasses[i]);
            }
        }

        public void encodeInto(ChannelHandlerContext ctx, IPacket msg, ByteBuf bytes) throws Exception {
            msg.writeBytes(ctx, bytes);
        }

        public void decodeInto(ChannelHandlerContext ctx, ByteBuf bytes, IPacket msg) {
            msg.readBytes(ctx, bytes);
        }
    }

    @ChannelHandler.Sharable
    public static class ChannelHandler
    extends SimpleChannelInboundHandler<IPacket> {
        protected void channelRead0(ChannelHandlerContext ctx, IPacket msg) throws Exception {
        }
    }

    public static interface IPacket {
        public void writeBytes(ChannelHandlerContext var1, ByteBuf var2);

        public void readBytes(ChannelHandlerContext var1, ByteBuf var2);
    }
}

