/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ChestChangerType;
import cpw.mods.ironchest.CommonProxy;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemIronChest;
import cpw.mods.ironchest.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

@Mod(modid="IronChest", name="Iron Chests", version="6.0.70", dependencies="required-after:Forge@[10.10,);required-after:FML@[7.2,)")
public class IronChest {
    public static BlockIronChest ironChestBlock;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="IronChest")
    public static IronChest instance;
    public static boolean CACHE_RENDER;
    public static boolean OCELOTS_SITONCHESTS;
    public static final String VERSION = "6.0.70";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            ChestChangerType.buildItems(cfg);
            CACHE_RENDER = cfg.get("general", "cacheRenderingInformation", true).getBoolean(true);
            OCELOTS_SITONCHESTS = cfg.get("general", "ocelotsSitOnChests", true).getBoolean(true);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"IronChest has a problem loading its configuration", (Object[])new Object[0]);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        ironChestBlock = new BlockIronChest();
        GameRegistry.registerBlock((Block)ironChestBlock, ItemIronChest.class, (String)"BlockIronChest");
        PacketHandler.INSTANCE.ordinal();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        for (IronChestType typ : IronChestType.values()) {
            if (typ.name().equals("STEEL")) {
                GameRegistry.registerTileEntityWithAlternatives(typ.clazz, (String)("IronChest." + typ.name()), (String[])new String[]{typ.name(), "SILVER", "IronChest.SILVER"});
            } else {
                GameRegistry.registerTileEntityWithAlternatives(typ.clazz, (String)("IronChest." + typ.name()), (String[])new String[]{typ.name()});
            }
            proxy.registerTileEntitySpecialRenderer(typ);
        }
        OreDictionary.registerOre((String)"chestWood", (Block)Blocks.field_150486_ae);
        IronChestType.registerBlocksAndRecipes(ironChestBlock);
        ChestChangerType.generateRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent evt) {
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (mapping.type == GameRegistry.Type.BLOCK) {
                switch (mapping.name) {
                    case "IronChest:copperSilverUpgrade": {
                        mapping.remap(GameRegistry.findBlock((String)"IronChest", (String)"copperSteelUpgrade"));
                        break;
                    }
                    case "IronChest:silverGoldUpgrade": {
                        mapping.remap(GameRegistry.findBlock((String)"IronChest", (String)"steelGoldUpgrade"));
                        break;
                    }
                }
                continue;
            }
            if (mapping.type != GameRegistry.Type.ITEM) continue;
            switch (mapping.name) {
                case "IronChest:copperSilverUpgrade": {
                    mapping.remap(GameRegistry.findItem((String)"IronChest", (String)"copperSteelUpgrade"));
                    break;
                }
                case "IronChest:silverGoldUpgrade": {
                    mapping.remap(GameRegistry.findItem((String)"IronChest", (String)"steelGoldUpgrade"));
                    break;
                }
            }
        }
    }

    static {
        CACHE_RENDER = true;
        OCELOTS_SITONCHESTS = true;
    }
}

