/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.ironchest;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLMissingMappingsEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.ironchest.BlockIronChest;
import cpw.mods.ironchest.ChestChangerType;
import cpw.mods.ironchest.CommonProxy;
import cpw.mods.ironchest.IronChestType;
import cpw.mods.ironchest.ItemIronChest;
import cpw.mods.ironchest.PacketHandler;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.logging.log4j.Level;

@Mod(modid="IronChest", name="Iron Chests", version="6.0.85", dependencies="required-after:Forge@[10.10,);required-after:FML@[7.2,)")
public class IronChest {
    public static BlockIronChest ironChestBlock;
    @SidedProxy(clientSide="cpw.mods.ironchest.client.ClientProxy", serverSide="cpw.mods.ironchest.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance(value="IronChest")
    public static IronChest instance;
    public static boolean CACHE_RENDER;
    public static boolean OCELOTS_SITONCHESTS;
    public static final String VERSION = "6.0.85";
    public static boolean TRANSPARENT_RENDER_INSIDE;
    public static double TRANSPARENT_RENDER_DISTANCE;
    public static boolean ENABLE_STEEL_CHESTS;
    public static boolean ENABLE_SILVER_CHESTS;
    public static boolean ENABLE_DARK_STEEL_CHESTS;
    public static boolean ENABLE_NETHERITE_CHESTS;
    public static String[] blocklistUpgrades;
    public static boolean isGTNHLoaded;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        isGTNHLoaded = Loader.isModLoaded((String)"dreamcraft");
        Configuration cfg = new Configuration(event.getSuggestedConfigurationFile());
        try {
            cfg.load();
            CACHE_RENDER = cfg.get("general", "cacheRenderingInformation", true).getBoolean(true);
            OCELOTS_SITONCHESTS = cfg.get("general", "ocelotsSitOnChests", true).getBoolean(true);
            TRANSPARENT_RENDER_INSIDE = cfg.get("general", "transparentRenderInside", true).getBoolean(true);
            TRANSPARENT_RENDER_DISTANCE = cfg.get("general", "transparentRenderDistance", 128.0).getDouble(128.0);
            ENABLE_STEEL_CHESTS = cfg.get("general", "enableSteelChests", true, "Enables the steel chest.").getBoolean(true);
            ENABLE_SILVER_CHESTS = cfg.get("general", "enableSilverChests", false, "Enables the silver chest.").getBoolean(false);
            ENABLE_DARK_STEEL_CHESTS = cfg.get("general", "enableDarkSteelChests", isGTNHLoaded, "Enables the dark steel.").getBoolean(isGTNHLoaded);
            ENABLE_NETHERITE_CHESTS = cfg.get("general", "enableNetheriteChests", !isGTNHLoaded, "Enables the netherite chest.").getBoolean(!isGTNHLoaded);
            blocklistUpgrades = cfg.getStringList("blocklistUpgrades", "general", new String[0], "Disallowed upgrades. All upgrades listed here will not be registred and no recipes will be generated for it.\nExample: IRON:GOLD");
            ChestChangerType.buildItems(cfg);
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"IronChest has a problem loading its configuration", (Object[])new Object[0]);
        }
        finally {
            if (cfg.hasChanged()) {
                cfg.save();
            }
        }
        ironChestBlock = new BlockIronChest();
        GameRegistry.registerBlock((Block)ironChestBlock, ItemIronChest.class, (String)"BlockIronChest");
        PacketHandler.INSTANCE.ordinal();
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        for (IronChestType typ : IronChestType.values()) {
            GameRegistry.registerTileEntityWithAlternatives(typ.clazz, (String)("IronChest." + typ.name()), (String[])new String[]{typ.name()});
            proxy.registerTileEntitySpecialRenderer(typ);
        }
        OreDictionary.registerOre((String)"chestWood", (Block)Blocks.field_150486_ae);
        IronChestType.registerBlocksAndRecipes(ironChestBlock);
        ChestChangerType.generateRecipes();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)proxy);
        proxy.registerRenderInformation();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Mod.EventHandler
    public void modsLoaded(FMLPostInitializationEvent evt) {
    }

    @Mod.EventHandler
    public void missingMapping(FMLMissingMappingsEvent event) {
        for (FMLMissingMappingsEvent.MissingMapping mapping : event.getAll()) {
            if (IronChestType.STEEL.isEnabled()) {
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    switch (mapping.name) {
                        case "IronChest:copperSilverUpgrade": {
                            mapping.remap(GameRegistry.findBlock((String)"IronChest", (String)"copperSteelUpgrade"));
                            break;
                        }
                        case "IronChest:silverGoldUpgrade": {
                            mapping.remap(GameRegistry.findBlock((String)"IronChest", (String)"steelGoldUpgrade"));
                            break;
                        }
                    }
                } else if (mapping.type == GameRegistry.Type.ITEM) {
                    switch (mapping.name) {
                        case "IronChest:copperSilverUpgrade": {
                            mapping.remap(GameRegistry.findItem((String)"IronChest", (String)"copperSteelUpgrade"));
                            break;
                        }
                        case "IronChest:silverGoldUpgrade": {
                            mapping.remap(GameRegistry.findItem((String)"IronChest", (String)"steelGoldUpgrade"));
                            break;
                        }
                    }
                }
            }
            if (IronChestType.DARKSTEEL.isEnabled()) {
                if (!mapping.name.equals("IronChest:obsidianNetheriteUpgrade")) continue;
                if (mapping.type == GameRegistry.Type.BLOCK) {
                    mapping.remap(GameRegistry.findBlock((String)"IronChest", (String)"diamondDarkSteelUpgrade"));
                    continue;
                }
                mapping.remap(GameRegistry.findItem((String)"IronChest", (String)"diamondDarkSteelUpgrade"));
                continue;
            }
            if (!IronChestType.NETHERITE.isEnabled() || !mapping.name.equals("IronChest:diamondDarkSteelUpgrade")) continue;
            if (mapping.type == GameRegistry.Type.BLOCK) {
                mapping.remap(GameRegistry.findBlock((String)"IronChest", (String)"obsidianNetheriteUpgrade"));
                continue;
            }
            mapping.remap(GameRegistry.findItem((String)"IronChest", (String)"obsidianNetheriteUpgrade"));
        }
    }

    static {
        CACHE_RENDER = true;
        OCELOTS_SITONCHESTS = true;
        TRANSPARENT_RENDER_INSIDE = true;
        TRANSPARENT_RENDER_DISTANCE = 128.0;
        ENABLE_STEEL_CHESTS = true;
        ENABLE_SILVER_CHESTS = false;
        ENABLE_DARK_STEEL_CHESTS = false;
        ENABLE_NETHERITE_CHESTS = true;
        blocklistUpgrades = new String[0];
    }
}

