/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.betterbarrels.client.render;

import mcp.mobius.betterbarrels.BetterBarrels;
import mcp.mobius.betterbarrels.client.render.TileEntityBaseRenderer;
import mcp.mobius.betterbarrels.common.StructuralLevel;
import mcp.mobius.betterbarrels.common.blocks.TileEntityBarrel;
import mcp.mobius.betterbarrels.common.blocks.logic.Coordinates;
import mcp.mobius.betterbarrels.common.items.IOverlayItem;
import mcp.mobius.betterbarrels.common.items.upgrades.UpgradeCore;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityBarrelRenderer
extends TileEntityBaseRenderer {
    public static TileEntityBarrelRenderer _instance = null;
    protected static ItemStack coreStorage = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 0);
    protected static ItemStack coreEnder = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 1);
    protected static ItemStack coreRedstone = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 2);
    protected static ItemStack coreHopper = new ItemStack(BetterBarrels.itemUpgradeCore, 0, 3);
    protected static ItemStack coreVoid = new ItemStack(BetterBarrels.itemUpgradeCore, 0, UpgradeCore.VOID.ordinal());
    protected static ItemStack coreCreative = new ItemStack(BetterBarrels.itemUpgradeCore, 0, UpgradeCore.CREATIVE.ordinal());

    public static TileEntityBarrelRenderer instance() {
        if (_instance == null) {
            _instance = new TileEntityBarrelRenderer();
        }
        return _instance;
    }

    public void func_147500_a(TileEntity tileEntity, double xpos, double ypos, double zpos, float var8) {
        if (tileEntity instanceof TileEntityBarrel && BetterBarrels.renderStackAndText && (xpos + 0.5) * (xpos + 0.5) + (ypos + 0.5) * (ypos + 0.5) + (zpos + 0.5) * (zpos + 0.5) < (double)BetterBarrels.renderDistance) {
            boolean isTopBottom;
            this.saveBoundTexture();
            int[][] savedGLState = this.modifyGLState(new int[]{3042, 2896}, null);
            ForgeDirection orientation = ((TileEntityBarrel)tileEntity).orientation;
            ForgeDirection rotation = ((TileEntityBarrel)tileEntity).rotation;
            TileEntityBarrel barrelEntity = (TileEntityBarrel)tileEntity;
            Coordinates barrelPos = new Coordinates(0, xpos, ypos, zpos);
            boolean isHammer = this.mc.field_71439_g.func_70694_bm() != null ? this.mc.field_71439_g.func_70694_bm().func_77973_b() instanceof IOverlayItem : false;
            boolean hasItem = barrelEntity.getStorage().hasItem();
            int color = StructuralLevel.LEVELS[barrelEntity.coreUpgrades.levelStructural].clientData.getTextColor();
            for (ForgeDirection forgeSide : ForgeDirection.VALID_DIRECTIONS) {
                boolean bl = isTopBottom = forgeSide == ForgeDirection.DOWN || forgeSide == ForgeDirection.UP;
                if (!hasItem || !this.isItemDisplaySide(barrelEntity, forgeSide)) continue;
                this.setLight(barrelEntity, forgeSide);
                this.renderStackOnBlock(barrelEntity.getStorage().getItemForRender(), forgeSide, isTopBottom ? rotation : orientation, barrelPos, 8.0f, 65.0, isTopBottom ? 64.0 : 75.0);
                String barrelString = this.getBarrelString(barrelEntity);
                this.renderTextOnBlock(barrelString, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 128.0, 10.0, color, TileEntityBaseRenderer.ALIGNCENTER);
            }
            if (isHammer) {
                for (ForgeDirection forgeSide : ForgeDirection.VALID_DIRECTIONS) {
                    int index;
                    isTopBottom = forgeSide == ForgeDirection.DOWN || forgeSide == ForgeDirection.UP;
                    this.setLight(barrelEntity, forgeSide);
                    if (barrelEntity.sideUpgrades[forgeSide.ordinal()] == 4) {
                        index = barrelEntity.sideMetadata[forgeSide.ordinal()] + 32;
                        this.renderIconOnBlock(index, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 224.0, 0.0, -0.01f);
                        continue;
                    }
                    if (barrelEntity.sideUpgrades[forgeSide.ordinal()] == 3) {
                        index = (barrelEntity.sideMetadata[forgeSide.ordinal()] & 1) + 32;
                        this.renderIconOnBlock(index, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 224.0, 0.0, -0.01f);
                        continue;
                    }
                    if (!this.isItemDisplaySide(barrelEntity, forgeSide)) continue;
                    int offsetY = 224;
                    if (barrelEntity.coreUpgrades.levelStructural > 0) {
                        this.renderIconOnBlock(StructuralLevel.LEVELS[barrelEntity.coreUpgrades.levelStructural].clientData.getIconItem(), 1, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 0.0, 0.0, -0.001f);
                        this.renderTextOnBlock("x" + String.valueOf(barrelEntity.coreUpgrades.levelStructural), forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 37.0, 15.0, color, TileEntityBaseRenderer.ALIGNLEFT);
                        if (barrelEntity.coreUpgrades.getFreeSlots() > 0) {
                            String freeSlots = String.valueOf(barrelEntity.coreUpgrades.getFreeSlots());
                            if (freeSlots.length() < 4) {
                                this.renderTextOnBlock(freeSlots, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 254.0, 127.0, color, TileEntityBaseRenderer.ALIGNRIGHT);
                            } else {
                                this.renderTextOnBlock(freeSlots, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 248.0, 134.0, 90.0f, color, TileEntityBaseRenderer.ALIGNCENTER);
                            }
                        }
                    }
                    if (barrelEntity.coreUpgrades.nStorageUpg > 0) {
                        this.renderStackOnBlock(coreStorage, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 224.0, 0.0);
                        this.renderTextOnBlock(String.valueOf(barrelEntity.coreUpgrades.nStorageUpg) + "x", forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 224.0, 15.0, color, TileEntityBaseRenderer.ALIGNRIGHT);
                    }
                    if (barrelEntity.coreUpgrades.hasRedstone) {
                        this.renderStackOnBlock(coreRedstone, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (barrelEntity.coreUpgrades.hasHopper) {
                        this.renderStackOnBlock(coreHopper, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (barrelEntity.coreUpgrades.hasEnder) {
                        this.renderStackOnBlock(coreEnder, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (barrelEntity.coreUpgrades.hasVoid) {
                        this.renderStackOnBlock(coreVoid, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 0.0, offsetY);
                        offsetY -= 35;
                    }
                    if (!barrelEntity.coreUpgrades.hasCreative) continue;
                    this.renderStackOnBlock(coreCreative, forgeSide, isTopBottom ? rotation : orientation, barrelPos, 2.0f, 0.0, offsetY);
                    offsetY -= 35;
                }
            }
            this.restoreGlState(savedGLState);
            this.loadBoundTexture();
        }
    }

    protected String getBarrelString(TileEntityBarrel barrel) {
        String outstring = null;
        if (!barrel.getStorage().hasItem()) {
            return "";
        }
        int maxstacksize = barrel.getStorage().getItem().func_77976_d();
        int amount = barrel.getStorage().getAmount();
        if (barrel.coreUpgrades.hasCreative) {
            outstring = "-";
        } else if (maxstacksize != 1) {
            int nstacks = amount / maxstacksize;
            int remains = amount % maxstacksize;
            if (nstacks > 0 && remains > 0) {
                outstring = String.format("%s*%s + %s", nstacks, maxstacksize, remains);
            } else if (nstacks == 0 && remains > 0) {
                outstring = String.format("%s", remains);
            } else if (nstacks > 0 && remains == 0) {
                outstring = String.format("%s*%s", nstacks, maxstacksize);
            } else if (amount == 0) {
                outstring = "0";
            }
        } else {
            outstring = maxstacksize == 1 ? String.format("%s", amount) : "";
        }
        return outstring;
    }

    protected boolean isItemDisplaySide(TileEntityBarrel barrel, ForgeDirection forgeSide) {
        if (barrel.sideUpgrades[forgeSide.ordinal()] == 0) {
            return false;
        }
        if (barrel.sideUpgrades[forgeSide.ordinal()] == 1) {
            return true;
        }
        return barrel.sideUpgrades[forgeSide.ordinal()] == 2;
    }
}

