/*
 * Decompiled with CFR 0.152.
 */
package mantle.books.external;

import com.google.common.base.Charsets;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import mantle.books.BookData;
import mantle.books.BookDataStore;
import mantle.books.ManualReader;
import mantle.books.client.BookImage;
import mantle.books.external.BookIS;
import mantle.books.external.BookLoad;
import mantle.lib.CoreRepo;
import mantle.lib.client.MantleClientRegistry;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class ZipLoader {
    public static Map<String, ItemStack> loadedIS = Maps.newHashMap();

    public static BookData loadZip(File f) {
        boolean isClient;
        String flName = new String();
        String flExt = new String();
        String lImg = new String();
        String rImg = new String();
        String bIcon = new String();
        String unlocName = new String();
        String toolTip = new String();
        Boolean translatable = false;
        BookData b = new BookData();
        boolean bl = isClient = FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT;
        if (f.exists()) {
            if (FilenameUtils.getExtension((String)f.getPath()).equalsIgnoreCase("zip")) {
                try {
                    CoreRepo.logger.info("Loading book zip " + f.getName());
                    ZipFile zipfile = new ZipFile(f);
                    Enumeration<? extends ZipEntry> e = zipfile.entries();
                    while (e.hasMoreElements()) {
                        ZipEntry entry = e.nextElement();
                        flName = entry.getName();
                        flExt = FilenameUtils.getExtension((String)flName);
                        if (entry.isDirectory()) continue;
                        if (isClient && ZipLoader.isImage(flExt)) {
                            String id = FilenameUtils.getBaseName((String)flName);
                            BufferedImage img = ImageIO.read(zipfile.getInputStream(entry));
                            DynamicTexture dynTexture = new DynamicTexture(img);
                            ResourceLocation rsLoc = Minecraft.func_71410_x().func_110434_K().func_110578_a(id, dynTexture);
                            BookImage bookImage = new BookImage(img.getWidth(), img.getHeight(), dynTexture, rsLoc);
                            MantleClientRegistry.imageCache.put(id, bookImage);
                        }
                        if (flExt.equalsIgnoreCase("xml")) {
                            b.doc = ManualReader.readManual(zipfile.getInputStream(entry), flName);
                        }
                        if (flExt.equalsIgnoreCase("lang")) {
                            // empty if block
                        }
                        if (!flExt.equalsIgnoreCase("json")) continue;
                        Gson g = new Gson();
                        BookLoad bl2 = (BookLoad)g.fromJson(IOUtils.toString((InputStream)zipfile.getInputStream(entry), (Charset)Charsets.UTF_8), BookLoad.class);
                        for (BookIS bookIS : bl2.registerItemStacks) {
                            try {
                                ItemStack is = loadedIS.get(bookIS.cname);
                                if (is != null) continue;
                                Block blok = (Block)Block.field_149771_c.func_82594_a(bookIS.cname);
                                Item it = (Item)Item.field_150901_e.func_82594_a(bookIS.cname);
                                if (it != null) {
                                    is = new ItemStack(it, bookIS.getStackSize(), bookIS.metadata);
                                } else if (bl2 != null) {
                                    is = new ItemStack(blok, bookIS.getStackSize(), bookIS.metadata);
                                }
                                if (is == null) continue;
                                if (bookIS.tags != null && !bookIS.tags.isEmpty()) {
                                    try {
                                        is.field_77990_d = (NBTTagCompound)JsonToNBT.func_150315_a((String)bookIS.tags);
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                loadedIS.put(bookIS.cname, is);
                            }
                            catch (Exception is) {
                                // empty catch block
                            }
                        }
                        if (isClient) {
                            String name;
                            ItemStack in;
                            ItemStack out;
                            for (BookIS bookIS : bl2.smallRecipes) {
                                if (bookIS == null) continue;
                                out = loadedIS.get(bookIS.get("out").getAsString());
                                in = ZipLoader.getISArray(bookIS.getAsJsonArray("in"));
                                name = bookIS.get("name").getAsString();
                                if (out == null || in == null || ((ItemStack[])in).length > 4 || name == null || name.isEmpty()) continue;
                                MantleClientRegistry.registerManualSmallRecipe(name, out, (ItemStack[])in);
                            }
                            for (BookIS bookIS : bl2.largeRecipes) {
                                if (bookIS == null) continue;
                                out = loadedIS.get(bookIS.get("out").getAsString());
                                in = ZipLoader.getISArray(bookIS.getAsJsonArray("in"));
                                name = bookIS.get("name").getAsString();
                                if (out == null || in == null || ((ItemStack[])in).length > 9 || name == null || name.isEmpty()) continue;
                                MantleClientRegistry.registerManualLargeRecipe(name, out, (ItemStack[])in);
                            }
                            for (BookIS bookIS : bl2.furnaceRecipes) {
                                if (bookIS == null) continue;
                                out = loadedIS.get(bookIS.get("out").getAsString());
                                in = loadedIS.get(bookIS.get("in").getAsString());
                                name = bookIS.get("name").getAsString();
                                if (out == null || in == null || name == null || name.isEmpty()) continue;
                                MantleClientRegistry.registerManualFurnaceRecipe(name, out, in);
                            }
                            for (BookIS bookIS : bl2.manualIcons) {
                                if (bookIS == null) continue;
                                ItemStack in2 = loadedIS.get(bookIS.get("stack").getAsString());
                                String name2 = bookIS.get("name").getAsString();
                                if (in2 == null || name2 == null || name2.isEmpty()) continue;
                                MantleClientRegistry.registerManualIcon(name2, in2);
                            }
                        }
                        b.unlocalizedName = bl2.unlocalizedName;
                        b.toolTip = bl2.tooltip;
                        b.isTranslatable = bl2.translatable;
                        b.leftImage = bl2.LeftImage == null ? new ResourceLocation("mantle", "textures/gui/bookleft.png") : MantleClientRegistry.getBookImageFromCache((String)bl2.LeftImage).resource;
                        b.rightImage = bl2.rightImage == null ? new ResourceLocation("mantle", "textures/gui/bookright.png") : MantleClientRegistry.getBookImageFromCache((String)bl2.rightImage).resource;
                        b.itemImage = bl2.BookIcon == null ? new ResourceLocation("mantle", "textures/items/mantlebook_blue.png") : MantleClientRegistry.getBookImageFromCache((String)bl2.BookIcon).resource;
                        b.isFromZip = true;
                        BookDataStore.addBook(b);
                    }
                    zipfile.close();
                    b.unlocalizedName = unlocName;
                    b.toolTip = toolTip;
                    b.isTranslatable = translatable;
                    b.leftImage = lImg == null ? new ResourceLocation("mantle", "textures/gui/bookleft.png") : MantleClientRegistry.getBookImageFromCache((String)lImg).resource;
                    b.rightImage = rImg == null ? new ResourceLocation("mantle", "textures/gui/bookright.png") : MantleClientRegistry.getBookImageFromCache((String)rImg).resource;
                    b.itemImage = bIcon == null ? new ResourceLocation("mantle", "textures/items/mantlebook_blue.png") : MantleClientRegistry.getBookImageFromCache((String)bIcon).resource;
                    b.isFromZip = true;
                    BookDataStore.addBook(b);
                }
                catch (Exception e) {
                    CoreRepo.logger.info(" Error Loading book zip " + f.getName());
                }
                return null;
            }
            CoreRepo.logger.error("Attempted to load non-zip file for mantle book. File " + f.getName() + " will be skipped");
        } else {
            CoreRepo.logger.error("Attempted to load non-existant file for mantle book. File will be skipped");
        }
        return null;
    }

    public static boolean isImage(String ext) {
        return ext.equalsIgnoreCase("png");
    }

    public static ItemStack[] getISArray(JsonArray a) {
        ItemStack[] is = new ItemStack[a.size()];
        for (int i = 0; i < a.size(); ++i) {
            if (a.get(i).getAsString() != null && !a.get(i).getAsString().isEmpty() && a.get(i).getAsString().equals("none")) {
                is[i] = null;
                continue;
            }
            ItemStack loadedStack = loadedIS.get(a.get(i).getAsString());
            if (loadedStack == null) {
                is = null;
                return is;
            }
            is[i] = loadedStack;
        }
        return is;
    }
}

