/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.pneumaticcraft.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.item.ItemStack;
import pneumaticCraft.api.recipe.PressureChamberRecipe;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.pneumaticcraft.Pressure")
public class Pressure {
    public static final String name = "PneumaticCraft Pressure Chamber";

    @ZenMethod
    public static void addRecipe(IItemStack[] input, double pressure, IItemStack[] output, boolean asBlock) {
        if (input == null || output == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        MineTweakerAPI.apply((IUndoableAction)new Add(new PressureChamberRecipe(InputHelper.toStacks(input), (float)pressure, InputHelper.toStacks(output), asBlock)));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient[] output) {
        LinkedList<PressureChamberRecipe> recipes = new LinkedList<PressureChamberRecipe>();
        for (PressureChamberRecipe r : PressureChamberRecipe.chamberRecipes) {
            if (r == null) continue;
            boolean matches = true;
            block1: for (IIngredient ingredient : output) {
                for (ItemStack stack : r.output) {
                    if (StackHelper.matches(ingredient, InputHelper.toIItemStack(stack))) continue;
                    matches = false;
                    continue block1;
                }
            }
            if (!matches) continue;
            recipes.add(r);
        }
        MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
    }

    private static class Remove
    extends BaseListRemoval<PressureChamberRecipe> {
        public Remove(List<PressureChamberRecipe> recipes) {
            super(Pressure.name, PressureChamberRecipe.chamberRecipes, recipes);
        }

        @Override
        public String getRecipeInfo(PressureChamberRecipe recipe) {
            return LogHelper.getStackDescription(recipe.output[0]);
        }
    }

    private static class Add
    extends BaseListAddition<PressureChamberRecipe> {
        public Add(PressureChamberRecipe recipe) {
            super(Pressure.name, PressureChamberRecipe.chamberRecipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(PressureChamberRecipe recipe) {
            return LogHelper.getStackDescription(recipe.output[0]);
        }
    }
}

