/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mariculture.handlers;

import java.util.HashMap;
import java.util.Map;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeCasting;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mariculture.MaricultureHelper;
import modtweaker2.utils.BaseMapAddition;
import modtweaker2.utils.BaseMapRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mariculture.Casting")
public class Casting {
    public static final String name = "Mariculture Casting";

    @ZenMethod
    public static void addNuggetRecipe(ILiquidStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add((RecipeCasting)new RecipeCasting.RecipeNuggetCasting(InputHelper.toFluid(input), InputHelper.toStack(output)), MaricultureHandlers.casting.getNuggetRecipes()));
    }

    @ZenMethod
    public static void addIngotRecipe(ILiquidStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add((RecipeCasting)new RecipeCasting.RecipeNuggetCasting(InputHelper.toFluid(input), InputHelper.toStack(output)), MaricultureHandlers.casting.getIngotRecipes()));
    }

    @ZenMethod
    public static void addBlockRecipe(ILiquidStack input, IItemStack output) {
        MineTweakerAPI.apply((IUndoableAction)new Add((RecipeCasting)new RecipeCasting.RecipeNuggetCasting(InputHelper.toFluid(input), InputHelper.toStack(output)), MaricultureHandlers.casting.getBlockRecipes()));
    }

    @ZenMethod
    public static void removeNuggetRecipe(IIngredient ingredient) {
        Casting.removeRecipe(ingredient, MaricultureHandlers.casting.getNuggetRecipes());
    }

    @ZenMethod
    public static void removeIngotRecipe(IIngredient ingredient) {
        Casting.removeRecipe(ingredient, MaricultureHandlers.casting.getIngotRecipes());
    }

    @ZenMethod
    public static void removeBlockRecipe(IIngredient ingredient) {
        Casting.removeRecipe(ingredient, MaricultureHandlers.casting.getBlockRecipes());
    }

    public static void removeRecipe(IIngredient ingredient, HashMap<String, RecipeCasting> map) {
        HashMap<String, RecipeCasting> recipes = new HashMap<String, RecipeCasting>();
        for (Map.Entry<String, RecipeCasting> recipe : map.entrySet()) {
            if (recipe == null || recipe.getValue() == null) continue;
            if (recipe.getValue().fluid != null && StackHelper.matches(ingredient, InputHelper.toILiquidStack(recipe.getValue().fluid))) {
                recipes.put(recipe.getKey(), recipe.getValue());
            }
            if (recipe.getValue().output == null || !StackHelper.matches(ingredient, InputHelper.toIItemStack(recipe.getValue().output))) continue;
            recipes.put(recipe.getKey(), recipe.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(map, recipes));
        }
    }

    private static class Remove
    extends BaseMapRemoval<String, RecipeCasting> {
        public Remove(Map<String, RecipeCasting> map, Map<String, RecipeCasting> recipes) {
            super(Casting.name, map, recipes);
        }

        @Override
        public String getRecipeInfo(Map.Entry<String, RecipeCasting> recipe) {
            return LogHelper.getStackDescription(recipe.getValue().output);
        }
    }

    private static class Add
    extends BaseMapAddition<String, RecipeCasting> {
        public Add(RecipeCasting recipe, HashMap<String, RecipeCasting> map) {
            super(Casting.name, map);
            this.recipes.put(MaricultureHelper.getKey(recipe.fluid), recipe);
        }

        @Override
        public String getRecipeInfo(Map.Entry<String, RecipeCasting> recipe) {
            return LogHelper.getStackDescription(recipe.getValue().output);
        }
    }
}

