/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botania.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipeManaInfusion;

@ZenClass(value="mods.botania.ManaInfusion")
public class ManaInfusion {
    protected static final String name = "Botania Mana Infusion";

    @ZenMethod
    public static void addInfusion(IItemStack output, IIngredient input, int mana) {
        MineTweakerAPI.apply((IUndoableAction)new Add(new RecipeManaInfusion(InputHelper.toStack(output), InputHelper.toObject(input), mana)));
    }

    @ZenMethod
    public static void addAlchemy(IItemStack output, IIngredient input, int mana) {
        RecipeManaInfusion recipe = new RecipeManaInfusion(InputHelper.toStack(output), InputHelper.toObject(input), mana);
        recipe.setAlchemy(true);
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void addConjuration(IItemStack output, IIngredient input, int mana) {
        RecipeManaInfusion recipe = new RecipeManaInfusion(InputHelper.toStack(output), InputHelper.toObject(input), mana);
        recipe.setConjuration(true);
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipeManaInfusion> recipes = new LinkedList<RecipeManaInfusion>();
        for (RecipeManaInfusion r : BotaniaAPI.manaInfusionRecipes) {
            if (r.getOutput() == null || !StackHelper.matches(output, InputHelper.toIItemStack(r.getOutput()))) continue;
            recipes.add(r);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        } else {
            LogHelper.logWarning(String.format("No %s Recipe found for %s. Command ignored!", name, output.toString()));
        }
    }

    private static class Remove
    extends BaseListRemoval<RecipeManaInfusion> {
        public Remove(List<RecipeManaInfusion> recipes) {
            super(ManaInfusion.name, BotaniaAPI.manaInfusionRecipes, recipes);
        }

        @Override
        public String getRecipeInfo(RecipeManaInfusion recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }

    private static class Add
    extends BaseListAddition<RecipeManaInfusion> {
        public Add(RecipeManaInfusion recipe) {
            super(ManaInfusion.name, BotaniaAPI.manaInfusionRecipes);
            this.recipes.add(recipe);
        }

        @Override
        public String getRecipeInfo(RecipeManaInfusion recipe) {
            return LogHelper.getStackDescription(recipe.getOutput());
        }
    }
}

