/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.mekanism.handlers;

import java.util.HashMap;
import java.util.Map;
import mekanism.common.recipe.RecipeHandler;
import mekanism.common.recipe.inputs.FluidInput;
import mekanism.common.recipe.inputs.MachineInput;
import mekanism.common.recipe.machines.MachineRecipe;
import mekanism.common.recipe.machines.SeparatorRecipe;
import mekanism.common.recipe.outputs.ChemicalPairOutput;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IngredientAny;
import minetweaker.api.liquid.ILiquidStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.mods.mekanism.MekanismHelper;
import modtweaker2.mods.mekanism.gas.IGasStack;
import modtweaker2.mods.mekanism.gas.MCGasStack;
import modtweaker2.mods.mekanism.util.AddMekanismRecipe;
import modtweaker2.mods.mekanism.util.RemoveMekanismRecipe;
import stanhebben.zenscript.annotations.Optional;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.mekanism.Separator")
public class Separator {
    public static final String name = "Mekanism Separator";

    @ZenMethod
    public static void addRecipe(ILiquidStack liquidInput, double energy, IGasStack leftGasOutput, IGasStack rightGasOutput) {
        if (liquidInput == null || leftGasOutput == null || rightGasOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        SeparatorRecipe recipe = new SeparatorRecipe(InputHelper.toFluid(liquidInput), energy, MekanismHelper.toGas(leftGasOutput), MekanismHelper.toGas(rightGasOutput));
        MineTweakerAPI.apply((IUndoableAction)new AddMekanismRecipe(name, (Map<MachineInput, MachineRecipe>)RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get(), (MachineRecipe)recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient liquidInput, @Optional IIngredient leftGasInput, @Optional IIngredient rightGasInput) {
        if (liquidInput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        if (leftGasInput == null) {
            leftGasInput = IngredientAny.INSTANCE;
        }
        if (rightGasInput == null) {
            leftGasInput = IngredientAny.INSTANCE;
        }
        HashMap<MachineInput, MachineRecipe> recipes = new HashMap<MachineInput, MachineRecipe>();
        for (Map.Entry entry : RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get().entrySet()) {
            ILiquidStack inputLiquid = InputHelper.toILiquidStack(((FluidInput)entry.getKey()).ingredient);
            MCGasStack outputItemLeft = new MCGasStack(((ChemicalPairOutput)((SeparatorRecipe)entry.getValue()).recipeOutput).leftGas);
            MCGasStack outputItemRight = new MCGasStack(((ChemicalPairOutput)((SeparatorRecipe)entry.getValue()).recipeOutput).rightGas);
            if (!StackHelper.matches(liquidInput, inputLiquid) || !StackHelper.matches(leftGasInput, outputItemLeft) || !StackHelper.matches(rightGasInput, outputItemRight)) continue;
            recipes.put((MachineInput)entry.getKey(), (MachineRecipe)entry.getValue());
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new RemoveMekanismRecipe(name, RecipeHandler.Recipe.ELECTROLYTIC_SEPARATOR.get(), (Map<MachineInput, MachineRecipe>)recipes));
        } else {
            LogHelper.logWarning(String.format("No %s recipe found for %s, %s and %s. Command ignored!", name, liquidInput.toString(), leftGasInput.toString(), rightGasInput.toString()));
        }
    }
}

