/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.botania.handlers;

import java.util.LinkedList;
import java.util.List;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import modtweaker2.helpers.InputHelper;
import modtweaker2.helpers.LogHelper;
import modtweaker2.helpers.StackHelper;
import modtweaker2.utils.BaseListAddition;
import modtweaker2.utils.BaseListRemoval;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.recipe.RecipePureDaisy;

@ZenClass(value="mods.botania.PureDaisy")
public class PureDaisy {
    public static final String name = "Botania PureDaisy";

    @ZenMethod
    public static void addRecipe(IIngredient blockInput, IItemStack blockOutput) {
        if (blockInput == null || blockOutput == null) {
            LogHelper.logError(String.format("Required parameters missing for %s Recipe.", name));
            return;
        }
        Object input = InputHelper.toObject(blockInput);
        if (input == null || input instanceof ItemStack && !InputHelper.isABlock((ItemStack)input)) {
            LogHelper.logError(String.format("Input must be a block or an oredict entry.", new Object[0]));
            return;
        }
        if (input instanceof ItemStack) {
            input = Block.func_149634_a((Item)((ItemStack)input).func_77973_b());
        }
        ItemStack output = InputHelper.toStack(blockOutput);
        RecipePureDaisy recipe = new RecipePureDaisy(input, Block.func_149634_a((Item)output.func_77973_b()), output.func_77960_j());
        MineTweakerAPI.apply((IUndoableAction)new Add(recipe));
    }

    @ZenMethod
    public static void removeRecipe(IIngredient output) {
        LinkedList<RecipePureDaisy> recipes = new LinkedList<RecipePureDaisy>();
        for (RecipePureDaisy recipe : BotaniaAPI.pureDaisyRecipes) {
            IItemStack out = InputHelper.toIItemStack(new ItemStack(recipe.getOutput(), 1, recipe.getOutputMeta()));
            if (!StackHelper.matches(output, out)) continue;
            recipes.add(recipe);
        }
        if (!recipes.isEmpty()) {
            MineTweakerAPI.apply((IUndoableAction)new Remove(recipes));
        }
    }

    private static class Remove
    extends BaseListRemoval<RecipePureDaisy> {
        public Remove(List<RecipePureDaisy> recipes) {
            super(PureDaisy.name, BotaniaAPI.pureDaisyRecipes, recipes);
        }

        @Override
        protected String getRecipeInfo(RecipePureDaisy recipe) {
            return LogHelper.getStackDescription(new ItemStack(recipe.getOutput(), 1, recipe.getOutputMeta()));
        }
    }

    private static class Add
    extends BaseListAddition<RecipePureDaisy> {
        public Add(RecipePureDaisy recipe) {
            super(PureDaisy.name, BotaniaAPI.pureDaisyRecipes);
            this.recipes.add(recipe);
        }

        @Override
        protected String getRecipeInfo(RecipePureDaisy recipe) {
            return LogHelper.getStackDescription(new ItemStack(recipe.getOutput(), 1, recipe.getOutputMeta()));
        }
    }
}

