/*
 * Decompiled with CFR 0.152.
 */
package modtweaker2.mods.thaumcraft.research;

import java.lang.reflect.Field;
import minetweaker.IUndoableAction;
import modtweaker2.mods.thaumcraft.ThaumcraftHelper;
import modtweaker2.mods.thaumcraft.handlers.Research;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchCategoryList;
import thaumcraft.api.research.ResearchItem;

public class SetResearch
implements IUndoableAction {
    String key;
    String tab;
    Research.SetType type;
    boolean flag;
    boolean applied = false;

    public SetResearch(String res, boolean f, Research.SetType typ) {
        this.key = res;
        this.tab = ThaumcraftHelper.getResearchTab(this.key);
        this.type = typ;
        this.flag = f;
    }

    public void apply() {
        ResearchItem research = (ResearchItem)((ResearchCategoryList)ResearchCategories.researchCategories.get((Object)this.tab)).research.get(this.key);
        if (this.flag) {
            if (this.type == Research.SetType.AUTO) {
                research.setAutoUnlock();
            } else if (this.type == Research.SetType.ROUND) {
                research.setRound();
            } else if (this.type == Research.SetType.SPIKE) {
                research.setSpecial();
            } else if (this.type == Research.SetType.SECONDARY) {
                research.setSecondary();
            } else if (this.type == Research.SetType.STUB) {
                research.setStub();
            } else if (this.type == Research.SetType.VIRTUAL) {
                research.setVirtual();
            } else if (this.type == Research.SetType.CONCEAL) {
                research.setConcealed();
            }
            this.applied = true;
        } else {
            try {
                Field target = null;
                if (this.type == Research.SetType.AUTO) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isAutoUnlock");
                } else if (this.type == Research.SetType.ROUND) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isRound");
                } else if (this.type == Research.SetType.SPIKE) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isSpecial");
                } else if (this.type == Research.SetType.SECONDARY) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isSecondary");
                } else if (this.type == Research.SetType.STUB) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isStub");
                } else if (this.type == Research.SetType.VIRTUAL) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isVirtual");
                } else if (this.type == Research.SetType.CONCEAL) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isConcealed");
                }
                if (target != null) {
                    target.setAccessible(true);
                    target.setBoolean(research, false);
                    this.applied = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String describe() {
        return "Setting tag for " + this.key;
    }

    public boolean canUndo() {
        return this.applied;
    }

    public void undo() {
        ResearchItem research = ThaumcraftHelper.getResearchSafe(this.tab, this.key);
        if (research == null) {
            return;
        }
        if (!this.flag) {
            if (this.type == Research.SetType.AUTO) {
                research.setAutoUnlock();
            } else if (this.type == Research.SetType.ROUND) {
                research.setRound();
            } else if (this.type == Research.SetType.SPIKE) {
                research.setSpecial();
            } else if (this.type == Research.SetType.SECONDARY) {
                research.setSecondary();
            } else if (this.type == Research.SetType.STUB) {
                research.setStub();
            } else if (this.type == Research.SetType.VIRTUAL) {
                research.setVirtual();
            } else if (this.type == Research.SetType.CONCEAL) {
                research.setConcealed();
            }
        } else {
            try {
                Field target = null;
                if (this.type == Research.SetType.AUTO) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isAutoUnlock");
                } else if (this.type == Research.SetType.ROUND) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isRound");
                } else if (this.type == Research.SetType.SPIKE) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isSpecial");
                } else if (this.type == Research.SetType.SECONDARY) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isSecondary");
                } else if (this.type == Research.SetType.STUB) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isStub");
                } else if (this.type == Research.SetType.VIRTUAL) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isVirtual");
                } else if (this.type == Research.SetType.CONCEAL) {
                    target = Class.forName("thaumcraft.api.research.ResearchItem").getDeclaredField("isConcealed");
                }
                if (target != null) {
                    target.setAccessible(true);
                    target.setBoolean(research, false);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public String describeUndo() {
        return "Reversing tag for " + this.key;
    }

    public String getOverrideKey() {
        return null;
    }
}

