/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.tooltip.Tooltip;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFormatting;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.init.Items;

class RelatedMaterialsHandler {
    private static final ImmutableList<OrePrefixes> REPRESENTATION_PREFIXES = ImmutableList.of((Object)OrePrefixes.ingot, (Object)OrePrefixes.dust, (Object)OrePrefixes.bucket, (Object)OrePrefixes.stone);
    private static final ImmutableSet<Materials> EXCLUDED_MATERIALS = ImmutableSet.of((Object)Materials.AnyCopper, (Object)Materials.AnyIron, (Object)Materials.Peanutwood);
    private ImmutableSetMultimap<Materials, Materials> relatedMaterials;
    private ImmutableMap<Materials, DisplayComponent> materialRepresentations;

    RelatedMaterialsHandler() {
    }

    void initialize() {
        SetMultimap relatedMaterials = MultimapBuilder.hashKeys().hashSetValues().build();
        HashMap<Materials, DisplayComponent> materialRepresentations = new HashMap<Materials, DisplayComponent>();
        for (Object material : Materials.getAll()) {
            if (EXCLUDED_MATERIALS.contains(material)) continue;
            relatedMaterials.putAll(material, RelatedMaterialsHandler.getRelatedMaterials((Materials)material));
        }
        SetMultimap reversed = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Materials key : relatedMaterials.keys()) {
            relatedMaterials.get((Object)key).forEach(value -> reversed.put(value, (Object)key));
        }
        relatedMaterials.putAll((Multimap)reversed);
        SetMultimap propagated = MultimapBuilder.hashKeys().hashSetValues().build();
        for (Materials key : relatedMaterials.keys()) {
            relatedMaterials.get((Object)key).forEach(value -> propagated.putAll((Object)key, (Iterable)relatedMaterials.get(value)));
            propagated.remove((Object)key, (Object)key);
            materialRepresentations.put(key, RelatedMaterialsHandler.getRepresentation(key));
        }
        relatedMaterials.putAll((Multimap)propagated);
        this.relatedMaterials = ImmutableSetMultimap.copyOf((Multimap)relatedMaterials);
        this.materialRepresentations = ImmutableMap.copyOf(materialRepresentations);
    }

    List<DisplayComponent> getRelatedMaterialRepresentations(Materials material) {
        return this.relatedMaterials.get((Object)material).stream().map(arg_0 -> this.materialRepresentations.get(arg_0)).collect(Collectors.toList());
    }

    private static Set<Materials> getRelatedMaterials(Materials material) {
        HashSet<Materials> relatedMaterials = new HashSet<Materials>();
        relatedMaterials.add(material.mSmeltInto);
        relatedMaterials.add(material.mMacerateInto);
        relatedMaterials.add(material.mArcSmeltInto);
        relatedMaterials.remove(material);
        relatedMaterials.remove(null);
        return relatedMaterials;
    }

    private static DisplayComponent getRepresentation(Materials material) {
        Optional<ItemComponent> representation = REPRESENTATION_PREFIXES.stream().map(prefix -> GregTechOreDictUtil.getComponent(prefix, material)).filter(Optional::isPresent).map(Optional::get).findFirst();
        if (!representation.isPresent()) {
            Logger.GREGTECH_5_MATERIAL_PARTS.warn("Could not find representation for material [{}]. Checked prefixes [{}].", new Object[]{material, REPRESENTATION_PREFIXES});
            representation = Optional.of(ItemComponent.create(Items.field_151042_j, 0));
        }
        return DisplayComponent.builder(representation.get()).setAdditionalTooltip(Tooltip.create(Lang.GREGTECH_5_MATERIAL_PARTS.transf("materiallabel", GregTechFormatting.getMaterialDescription(material)), Tooltip.INFO_FORMATTING)).build();
    }
}

