/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.api.diagram;

import codechicken.nei.NEIClientConfig;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.api.IOverlayHandler;
import codechicken.nei.api.IRecipeOverlayRenderer;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.ICraftingHandler;
import codechicken.nei.recipe.IUsageHandler;
import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramState;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.FluidComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.InteractiveComponentGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.DiagramMatcher;
import com.github.dcysteine.neicustomdiagram.api.draw.Dimension;
import com.github.dcysteine.neicustomdiagram.api.draw.GuiManager;
import com.github.dcysteine.neicustomdiagram.api.draw.Point;
import com.github.dcysteine.neicustomdiagram.main.config.ConfigOptions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class DiagramGroup
implements ICraftingHandler,
IUsageHandler {
    protected final DiagramGroupInfo info;
    protected final DiagramMatcher matcher;
    protected final Supplier<DiagramState> diagramStateSupplier;
    protected final GuiManager guiManager;
    protected final DiagramState diagramState;
    protected final ImmutableList<Diagram> diagrams;

    public DiagramGroup(DiagramGroupInfo info, DiagramMatcher matcher, Supplier<DiagramState> diagramStateSupplier) {
        this.info = info;
        this.matcher = matcher;
        this.diagramStateSupplier = diagramStateSupplier;
        this.guiManager = new GuiManager();
        this.diagramState = diagramStateSupplier.get();
        this.diagrams = ImmutableList.of();
    }

    public DiagramGroup(DiagramGroupInfo info, DiagramMatcher matcher) {
        this(info, matcher, DiagramState::new);
    }

    public DiagramGroup(DiagramGroup parent, Iterable<? extends Diagram> diagrams) {
        this.info = parent.info;
        this.matcher = parent.matcher;
        this.diagramStateSupplier = parent.diagramStateSupplier;
        this.guiManager = new GuiManager();
        this.diagramState = this.diagramStateSupplier.get();
        this.diagrams = ImmutableList.copyOf(diagrams);
    }

    public DiagramGroupInfo info() {
        return this.info;
    }

    public DiagramGroup newInstance(Iterable<? extends Diagram> diagrams) {
        return new DiagramGroup(this, diagrams);
    }

    public String getHandlerId() {
        return this.info.groupId();
    }

    public String getRecipeName() {
        return this.info.groupName();
    }

    public int recipiesPerPage() {
        return this.info.diagramsPerPage();
    }

    public int numRecipes() {
        return this.diagrams.size();
    }

    public DiagramGroup loadDiagrams(String id, Interactable.RecipeType recipeType, Object ... stacks) {
        Collection matchingDiagrams = this.matchDiagrams(id, recipeType, stacks);
        if (!ConfigOptions.SHOW_EMPTY_DIAGRAMS.get().booleanValue()) {
            matchingDiagrams = matchingDiagrams.stream().filter(diagram -> !this.info.emptyDiagramPredicate().test((Diagram)diagram)).collect(Collectors.toList());
        }
        return this.newInstance(matchingDiagrams);
    }

    protected Collection<Diagram> matchDiagrams(String id, Interactable.RecipeType recipeType, Object ... stacks) {
        if (id.equals(this.info.groupId())) {
            return this.matcher.all();
        }
        if (!ConfigOptions.getDiagramGroupVisibility(this.info).isShown()) {
            return ImmutableList.of();
        }
        switch (id) {
            case "item": {
                ItemStack itemStack = (ItemStack)stacks[0];
                ItemComponent itemComponent = this.info.ignoreNbt() ? ItemComponent.create(itemStack) : ItemComponent.createWithNbt(itemStack);
                return this.matcher.match(recipeType, itemComponent);
            }
            case "liquid": 
            case "fluid": {
                FluidStack fluidStack = (FluidStack)stacks[0];
                FluidComponent fluidComponent = this.info.ignoreNbt() ? FluidComponent.create(fluidStack) : FluidComponent.createWithNbt(fluidStack);
                return this.matcher.match(recipeType, fluidComponent);
            }
        }
        return ImmutableList.of();
    }

    public final ICraftingHandler getRecipeHandler(String outputId, Object ... results) {
        return this.loadDiagrams(outputId, Interactable.RecipeType.CRAFTING, results);
    }

    public final IUsageHandler getUsageHandler(String inputId, Object ... ingredients) {
        return this.loadDiagrams(inputId, Interactable.RecipeType.USAGE, ingredients);
    }

    @OverridingMethodsMustInvokeSuper
    public void onUpdate() {
        this.guiManager.tick();
        this.diagramState.tick();
    }

    public void drawBackground(int recipe) {
        Diagram diagram = (Diagram)this.diagrams.get(recipe);
        Dimension diagramDimension = diagram.dimension(this.diagramState);
        this.guiManager.checkScrollState(diagramDimension);
        this.guiManager.beforeDraw(diagramDimension);
        diagram.drawBackground(this.diagramState);
        this.guiManager.afterDraw(diagramDimension);
    }

    public void drawForeground(int recipe) {
        Diagram diagram = (Diagram)this.diagrams.get(recipe);
        Dimension diagramDimension = diagram.dimension(this.diagramState);
        this.guiManager.beforeDraw(diagramDimension);
        diagram.drawForeground(this.diagramState);
        Optional<Interactable> interactable = this.findHoveredInteractable(recipe);
        interactable.ifPresent(i -> i.drawOverlay(this.diagramState));
        this.guiManager.afterDraw(diagramDimension);
    }

    public void drawTooltip(GuiRecipe gui, int recipe) {
        Diagram diagram = (Diagram)this.diagrams.get(recipe);
        Dimension diagramDimension = diagram.dimension(this.diagramState);
        this.guiManager.drawScrollbar(diagramDimension);
        Optional<Interactable> interactable = this.findHoveredInteractable(recipe);
        interactable.ifPresent(i -> i.drawTooltip(this.diagramState, this.guiManager.getAbsoluteMousePosition()));
    }

    protected Optional<Interactable> findHoveredInteractable(int recipe) {
        if (!this.mouseInBounds()) {
            return Optional.empty();
        }
        Point mousePos = this.guiManager.getRelativeMousePosition(recipe);
        for (Interactable interactable : ((Diagram)this.diagrams.get(recipe)).interactables(this.diagramState)) {
            if (!interactable.checkBoundingBox(mousePos)) continue;
            return Optional.of(interactable);
        }
        return Optional.empty();
    }

    public boolean mouseInBounds() {
        return this.guiManager.mouseInBounds();
    }

    public boolean interact(int recipe, Interactable.RecipeType recipeType) {
        Optional<Interactable> interactable = this.findHoveredInteractable(recipe);
        if (interactable.isPresent()) {
            interactable.get().interact(this.diagramState, recipeType);
            return true;
        }
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int recipe) {
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.recipe")) {
            return this.interact(recipe, Interactable.RecipeType.CRAFTING);
        }
        if (keyCode == NEIClientConfig.getKeyBinding((String)"gui.usage")) {
            return this.interact(recipe, Interactable.RecipeType.USAGE);
        }
        return false;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int recipe) {
        boolean handled = this.guiManager.mouseClickScrollbar(button == 0 ? GuiManager.MouseButton.LEFT : GuiManager.MouseButton.RIGHT, ((Diagram)this.diagrams.get(recipe)).dimension(this.diagramState));
        if (handled) {
            return true;
        }
        switch (button) {
            case 0: {
                return this.interact(recipe, Interactable.RecipeType.CRAFTING);
            }
            case 1: {
                return this.interact(recipe, Interactable.RecipeType.USAGE);
            }
        }
        return false;
    }

    public boolean mouseScrolled(GuiRecipe gui, int scroll, int recipe) {
        GuiManager.ScrollDirection direction;
        if (!this.mouseInBounds() && !this.guiManager.mouseInScrollBounds()) {
            return false;
        }
        GuiManager.ScrollDirection scrollDirection = direction = scroll > 0 ? GuiManager.ScrollDirection.UP : GuiManager.ScrollDirection.DOWN;
        if (NEIClientUtils.shiftKey()) {
            this.diagramState.scroll(direction);
            return true;
        }
        Diagram diagram = (Diagram)this.diagrams.get(recipe);
        Dimension diagramDimension = diagram.dimension(this.diagramState);
        if (this.guiManager.isScrollable(diagramDimension)) {
            this.guiManager.scroll(direction);
            return true;
        }
        return ConfigOptions.DISABLE_PAGE_SCROLL.get();
    }

    public Optional<ItemStack> getStackUnderMouse(int recipe) {
        Optional<Interactable> interactableOptional = this.findHoveredInteractable(recipe);
        if (!interactableOptional.isPresent()) {
            return Optional.empty();
        }
        Interactable interactable = interactableOptional.get();
        if (!(interactable instanceof InteractiveComponentGroup)) {
            return Optional.empty();
        }
        DisplayComponent component = ((InteractiveComponentGroup)interactable).currentComponent(this.diagramState);
        if (component.type() == Component.ComponentType.ITEM) {
            return Optional.of((ItemStack)component.stack());
        }
        return Optional.empty();
    }

    public boolean hasOverlay(GuiContainer gui, Container container, int recipe) {
        return false;
    }

    public IRecipeOverlayRenderer getOverlayRenderer(GuiContainer gui, int recipe) {
        return null;
    }

    public IOverlayHandler getOverlayHandler(GuiContainer gui, int recipe) {
        return null;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int recipe) {
        this.drawTooltip(gui, recipe);
        return currenttip;
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int recipe) {
        return currenttip;
    }

    public List<PositionedStack> getIngredientStacks(int recipe) {
        return ImmutableList.of();
    }

    public List<PositionedStack> getOtherStacks(int recipetype) {
        return ImmutableList.of();
    }

    public PositionedStack getResultStack(int recipe) {
        return null;
    }
}

