/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits;

import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.AutoValue_CircuitLine;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@AutoValue
abstract class CircuitLine {
    static final int MAX_TIER = 10;

    CircuitLine() {
    }

    abstract ImmutableList<ItemComponent> boards();

    abstract int startTier();

    abstract ImmutableList<ItemComponent> circuits();

    static Builder builder() {
        return new Builder();
    }

    static final class Builder {
        private final List<ItemComponent> boards = new ArrayList<ItemComponent>();
        private int startTier = 0;
        private final List<ItemComponent> circuits = new ArrayList<ItemComponent>();

        private Builder() {
        }

        Builder addBoard(ItemComponent board) {
            this.boards.add(board);
            return this;
        }

        Builder addBoards(ItemComponent ... boards) {
            this.boards.addAll(Arrays.asList(boards));
            return this;
        }

        Builder setStartTier(int tier) {
            this.startTier = tier;
            return this;
        }

        Builder addCircuit(ItemComponent circuit) {
            this.circuits.add(circuit);
            return this;
        }

        Builder addCircuits(ItemComponent ... circuits) {
            this.circuits.addAll(Arrays.asList(circuits));
            return this;
        }

        CircuitLine build() {
            Preconditions.checkArgument((this.startTier + this.circuits.size() <= 11 ? 1 : 0) != 0, (String)"Too many circuits: (%d + %d) > (%d + 1)", (Object[])new Object[]{this.startTier, this.circuits.size(), 10});
            return new AutoValue_CircuitLine((ImmutableList<ItemComponent>)ImmutableList.copyOf(this.boards), this.startTier, (ImmutableList<ItemComponent>)ImmutableList.copyOf(this.circuits));
        }
    }
}

