/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits;

import com.dreammaster.gthandler.CustomItemList;
import com.github.bartimaeusnek.bartworks.system.material.CircuitGeneration.BW_Meta_Items;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.DisplayComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.AutoValue_CircuitLineHandler_CircuitLineCircuits;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.CircuitLine;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.circuits.GregTechCircuits;
import com.github.dcysteine.neicustomdiagram.main.Registry;
import com.github.dcysteine.neicustomdiagram.util.dreamcraft.DreamcraftUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import gregtech.api.enums.ItemList;
import gregtech.api.util.GT_ModHandler;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

class CircuitLineHandler {
    private ImmutableList<CircuitLine> circuitLines;
    private ImmutableList<CircuitLine> individualCircuits;
    private ImmutableList<ItemComponent> additionalDiagramItems;
    private ImmutableList<ImmutableList<ItemComponent>> circuitParts;
    private ImmutableMap<ItemComponent, CircuitLineCircuits> circuitLineCircuits;
    private ImmutableListMultimap<ItemComponent, DisplayComponent> tierCircuits;

    CircuitLineHandler() {
    }

    void initialize() {
        Object circuits;
        ImmutableList.Builder circuitLinesBuilder = ImmutableList.builder();
        if (Registry.ModDependency.BARTWORKS.isLoaded()) {
            CircuitLine.Builder circuitLineBuilder = CircuitLine.builder().addBoard(ItemComponent.create(BW_Meta_Items.getNEWCIRCUITS().getStack(new int[]{3}))).setStartTier(0);
            IntStream.rangeClosed(4, 14).mapToObj(i -> ItemComponent.create(BW_Meta_Items.getNEWCIRCUITS().getStack(new int[]{i}))).forEach(circuitLineBuilder::addCircuit);
            circuitLinesBuilder.add((Object)circuitLineBuilder.build());
        }
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoards(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Coated_Basic), GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Phenolic_Good)).setStartTier(0).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Primitive), ItemComponent.create(GT_ModHandler.getIC2Item((String)"electronicCircuit", (long)1L)), GregTechOreDictUtil.getComponent(ItemList.Circuit_Good)).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoards(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Coated_Basic), GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Phenolic_Good)).setStartTier(1).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Basic), GregTechOreDictUtil.getComponent(ItemList.Circuit_Integrated_Good), ItemComponent.create(GT_ModHandler.getIC2Item((String)"advancedCircuit", (long)1L))).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Plastic_Advanced)).setStartTier(2).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Processor), GregTechOreDictUtil.getComponent(ItemList.Circuit_Advanced), GregTechOreDictUtil.getComponent(ItemList.Circuit_Data), GregTechOreDictUtil.getComponent(ItemList.Circuit_Elite)).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Epoxy_Advanced)).setStartTier(3).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Nanoprocessor), GregTechOreDictUtil.getComponent(ItemList.Circuit_Nanocomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Elitenanocomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Master)).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Fiberglass_Advanced)).setStartTier(4).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Quantumprocessor), GregTechOreDictUtil.getComponent(ItemList.Circuit_Quantumcomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Masterquantumcomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Quantummainframe)).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Multifiberglass_Elite)).setStartTier(5).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Crystalprocessor), GregTechOreDictUtil.getComponent(ItemList.Circuit_Crystalcomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Ultimatecrystalcomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Crystalmainframe)).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Wetware_Extreme)).setStartTier(6).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Neuroprocessor), GregTechOreDictUtil.getComponent(ItemList.Circuit_Wetwarecomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Wetwaresupercomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Wetwaremainframe)).build());
        circuitLinesBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Bio_Ultra)).setStartTier(7).addCircuits(GregTechOreDictUtil.getComponent(ItemList.Circuit_Bioprocessor), GregTechOreDictUtil.getComponent(ItemList.Circuit_Biowarecomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Biowaresupercomputer), GregTechOreDictUtil.getComponent(ItemList.Circuit_Biomainframe)).build());
        this.circuitLines = circuitLinesBuilder.build();
        ImmutableList.Builder individualCircuitsBuilder = ImmutableList.builder();
        if (Registry.ModDependency.GTNH_CORE_MOD.isLoaded()) {
            individualCircuitsBuilder.add((Object)CircuitLine.builder().addBoard(DreamcraftUtil.getComponent(CustomItemList.NandChipBoard)).setStartTier(0).addCircuit(GregTechOreDictUtil.getComponent(ItemList.NandChip)).build());
        } else {
            individualCircuitsBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Phenolic_Good)).setStartTier(0).addCircuit(GregTechOreDictUtil.getComponent(ItemList.NandChip)).build());
        }
        individualCircuitsBuilder.add((Object)CircuitLine.builder().addBoard(GregTechOreDictUtil.getComponent(ItemList.Circuit_Board_Plastic_Advanced)).setStartTier(1).addCircuit(GregTechOreDictUtil.getComponent(ItemList.Circuit_Microprocessor)).build());
        this.individualCircuits = individualCircuitsBuilder.build();
        ImmutableList.Builder additionalDiagramItemsBuilder = ImmutableList.builder();
        if (Registry.ModDependency.GTNH_CORE_MOD.isLoaded()) {
            additionalDiagramItemsBuilder.add((Object)DreamcraftUtil.getComponent(CustomItemList.NandChipBoard));
        }
        this.additionalDiagramItems = additionalDiagramItemsBuilder.build();
        ImmutableList.Builder circuitPartsBuilder = ImmutableList.builder();
        circuitPartsBuilder.add((Object)ImmutableList.of((Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_Resistor), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_ResistorSMD), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_ResistorASMD)));
        circuitPartsBuilder.add((Object)ImmutableList.of((Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_Diode), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_DiodeSMD), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_DiodeASMD)));
        circuitPartsBuilder.add((Object)ImmutableList.of((Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_Transistor), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_TransistorSMD), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_TransistorASMD)));
        circuitPartsBuilder.add((Object)ImmutableList.of((Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_Capacitor), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_CapacitorSMD), (Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_CapacitorASMD)));
        circuitPartsBuilder.add((Object)ImmutableList.of((Object)GregTechOreDictUtil.getComponent(ItemList.Circuit_Parts_Coil)));
        this.circuitParts = circuitPartsBuilder.build();
        ImmutableMap.Builder circuitLineCircuitsBuilder = ImmutableMap.builder();
        ListMultimap tierCircuitsMap = MultimapBuilder.hashKeys().arrayListValues().build();
        for (CircuitLine circuitLine : this.circuitLines) {
            ItemComponent previousCircuit = null;
            circuits = circuitLine.circuits();
            for (int i2 = 0; i2 < circuits.size(); ++i2) {
                ItemComponent currentCircuit = (ItemComponent)circuits.get(i2);
                int tier = circuitLine.startTier() + i2;
                circuitLineCircuitsBuilder.put((Object)currentCircuit, (Object)CircuitLineCircuits.builder(currentCircuit, tier).setPreviousCircuit(previousCircuit).setNextCircuit(i2 < circuits.size() - 1 ? (ItemComponent)circuits.get(i2 + 1) : null).build());
                previousCircuit = currentCircuit;
                tierCircuitsMap.put((Object)tier, (Object)currentCircuit);
            }
        }
        for (CircuitLine circuitLine : this.individualCircuits) {
            ItemComponent circuit2 = (ItemComponent)Iterables.getOnlyElement(circuitLine.circuits());
            circuitLineCircuitsBuilder.put((Object)circuit2, (Object)CircuitLineCircuits.EMPTY);
            tierCircuitsMap.put((Object)circuitLine.startTier(), (Object)circuit2);
        }
        this.circuitLineCircuits = circuitLineCircuitsBuilder.build();
        ImmutableListMultimap.Builder tierCircuitsBuilder = ImmutableListMultimap.builder();
        for (Map.Entry entry : tierCircuitsMap.asMap().entrySet()) {
            circuits = (Collection)entry.getValue();
            List displayCircuits = circuits.stream().map(circuit -> GregTechCircuits.buildCircuitDisplayComponent(circuit, (Integer)entry.getKey())).collect(Collectors.toList());
            circuits.forEach(circuit -> tierCircuitsBuilder.putAll(circuit, (Iterable)displayCircuits));
        }
        this.tierCircuits = tierCircuitsBuilder.build();
    }

    Set<ItemComponent> allCircuits() {
        HashSet allCircuits = Sets.newHashSet(this.additionalDiagramItems);
        for (CircuitLine circuitLine : Iterables.concat(this.circuitLines, this.individualCircuits)) {
            allCircuits.addAll(circuitLine.circuits());
        }
        return allCircuits;
    }

    int circuitLinesSize() {
        return this.circuitLines.size();
    }

    int individualCircuitsSize() {
        return this.individualCircuits.size();
    }

    int circuitPartsSize() {
        return this.circuitParts.size();
    }

    int circuitPartsSubListMaxSize() {
        return this.circuitParts.stream().mapToInt(List::size).max().getAsInt();
    }

    ImmutableList<CircuitLine> circuitLines() {
        return this.circuitLines;
    }

    ImmutableList<CircuitLine> individualCircuits() {
        return this.individualCircuits;
    }

    ImmutableList<ImmutableList<ItemComponent>> circuitParts() {
        return this.circuitParts;
    }

    CircuitLineCircuits circuitLineCircuits(ItemComponent circuit) {
        return (CircuitLineCircuits)this.circuitLineCircuits.getOrDefault((Object)circuit, (Object)CircuitLineCircuits.EMPTY);
    }

    ImmutableList<DisplayComponent> tierCircuits(ItemComponent circuit) {
        return this.tierCircuits.get((Object)circuit);
    }

    @AutoValue
    static abstract class CircuitLineCircuits {
        private static final CircuitLineCircuits EMPTY = new AutoValue_CircuitLineHandler_CircuitLineCircuits(Optional.empty(), Optional.empty(), Optional.empty());

        CircuitLineCircuits() {
        }

        abstract Optional<DisplayComponent> previousCircuit();

        abstract Optional<DisplayComponent> currentCircuit();

        abstract Optional<DisplayComponent> nextCircuit();

        private static Builder builder(ItemComponent currentCircuit, int tier) {
            return new Builder(currentCircuit, tier);
        }

        private static final class Builder {
            @Nullable
            private ItemComponent previousCircuit;
            private final ItemComponent currentCircuit;
            @Nullable
            private ItemComponent nextCircuit;
            private final int tier;

            private Builder(ItemComponent currentCircuit, int tier) {
                this.tier = tier;
                this.previousCircuit = null;
                this.currentCircuit = currentCircuit;
                this.nextCircuit = null;
            }

            Builder setPreviousCircuit(@Nullable ItemComponent previousCircuit) {
                this.previousCircuit = previousCircuit;
                return this;
            }

            Builder setNextCircuit(@Nullable ItemComponent nextCircuit) {
                this.nextCircuit = nextCircuit;
                return this;
            }

            CircuitLineCircuits build() {
                if (this.previousCircuit == null && this.nextCircuit == null) {
                    return EMPTY;
                }
                return new AutoValue_CircuitLineHandler_CircuitLineCircuits(this.buildCircuitDisplayComponent(this.previousCircuit, this.tier - 1), this.buildCircuitDisplayComponent(this.currentCircuit, this.tier), this.buildCircuitDisplayComponent(this.nextCircuit, this.tier + 1));
            }

            private Optional<DisplayComponent> buildCircuitDisplayComponent(@Nullable ItemComponent circuit, int tier) {
                return Optional.ofNullable(circuit).map(c -> GregTechCircuits.buildCircuitDisplayComponent(circuit, tier));
            }
        }
    }
}

