/*
 * Decompiled with CFR 0.152.
 */
package com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts;

import com.github.dcysteine.neicustomdiagram.api.diagram.Diagram;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGenerator;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroup;
import com.github.dcysteine.neicustomdiagram.api.diagram.DiagramGroupInfo;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.Component;
import com.github.dcysteine.neicustomdiagram.api.diagram.component.ItemComponent;
import com.github.dcysteine.neicustomdiagram.api.diagram.interactable.Interactable;
import com.github.dcysteine.neicustomdiagram.api.diagram.matcher.CustomDiagramMatcher;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts.DiagramFactory;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts.HeatingCoilHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts.LayoutHandler;
import com.github.dcysteine.neicustomdiagram.generators.gregtech5.materialparts.RelatedMaterialsHandler;
import com.github.dcysteine.neicustomdiagram.main.Lang;
import com.github.dcysteine.neicustomdiagram.main.Logger;
import com.github.dcysteine.neicustomdiagram.util.DiagramUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFluidDictUtil;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechFormatting;
import com.github.dcysteine.neicustomdiagram.util.gregtech5.GregTechOreDictUtil;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.Lists;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.objects.ItemData;
import java.util.List;
import java.util.Optional;
import net.minecraft.init.Items;

public final class GregTechMaterialParts
implements DiagramGenerator {
    public static final ItemComponent ICON = GregTechOreDictUtil.getComponent(OrePrefixes.gearGt, Materials.Aluminium).orElse(ItemComponent.create(Items.field_151042_j, 0));
    private final DiagramGroupInfo info;
    private final LayoutHandler layoutHandler;
    private final HeatingCoilHandler heatingCoilHandler;
    private final RelatedMaterialsHandler relatedMaterialsHandler;
    private final DiagramFactory diagramFactory;
    private ImmutableBiMap<Materials, Diagram> materialsMap;

    public GregTechMaterialParts(String groupId) {
        this.info = DiagramGroupInfo.builder(Lang.GREGTECH_5_MATERIAL_PARTS.trans("groupname"), groupId, ICON, 1).setEmptyDiagramPredicate(DiagramUtil.buildEmptyDiagramPredicate(2)).setDescription("This diagram displays GregTech crafting items for each GregTech material.").build();
        this.layoutHandler = new LayoutHandler(this.info);
        this.heatingCoilHandler = new HeatingCoilHandler();
        this.relatedMaterialsHandler = new RelatedMaterialsHandler();
        this.diagramFactory = new DiagramFactory(this.layoutHandler, this.heatingCoilHandler, this.relatedMaterialsHandler);
        this.materialsMap = null;
    }

    @Override
    public DiagramGroupInfo info() {
        return this.info;
    }

    @Override
    public DiagramGroup generate() {
        this.layoutHandler.initialize();
        this.heatingCoilHandler.initialize();
        this.relatedMaterialsHandler.initialize();
        ImmutableBiMap.Builder materialsMapBuilder = ImmutableBiMap.builder();
        for (Materials material : Materials.getAll()) {
            materialsMapBuilder.put((Object)material, (Object)this.diagramFactory.buildDiagram(material));
        }
        this.materialsMap = materialsMapBuilder.build();
        return new DiagramGroup(this.info, new CustomDiagramMatcher((Iterable<? extends Diagram>)this.materialsMap.values(), this::getDiagram));
    }

    private List<Diagram> getDiagram(Interactable.RecipeType unused, Component component) {
        Materials material;
        Optional<ItemData> itemDataOptional = GregTechOreDictUtil.getItemData(component = GregTechFluidDictUtil.fillCell(component).map(Component.class::cast).orElse(component));
        if (itemDataOptional.isPresent() && itemDataOptional.get().mMaterial != null && (material = itemDataOptional.get().mMaterial.mMaterial) != null) {
            if (this.materialsMap.containsKey((Object)material)) {
                return Lists.newArrayList((Object[])new Diagram[]{(Diagram)this.materialsMap.get((Object)material)});
            }
            Logger.GREGTECH_5_MATERIAL_PARTS.error("Did not generate diagram for material: {}", new Object[]{GregTechFormatting.getMaterialDescription(material)});
        }
        return Lists.newArrayList();
    }
}

